/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.client;

import com.google.gerrit.extensions.client.Side;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Objects;

public abstract class Comment {
    public Integer patchSet;
    public String id;
    public String path;
    public Side side;
    public Integer parent;
    public Integer line;
    public Range range;
    public String inReplyTo;
    public Timestamp updated;
    public String message;
    public Boolean unresolved;
    public String commitId;

    public short side() {
        if (this.side == Side.PARENT) {
            return this.parent == null ? (short)0 : -this.parent.shortValue();
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            Comment c = (Comment)o;
            return Objects.equals(this.patchSet, c.patchSet) && Objects.equals(this.id, c.id) && Objects.equals(this.path, c.path) && Objects.equals((Object)this.side, (Object)c.side) && Objects.equals(this.parent, c.parent) && Objects.equals(this.line, c.line) && Objects.equals(this.range, c.range) && Objects.equals(this.inReplyTo, c.inReplyTo) && Objects.equals(this.updated, c.updated) && Objects.equals(this.message, c.message) && Objects.equals(this.unresolved, c.unresolved) && Objects.equals(this.commitId, c.commitId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.patchSet, this.id, this.path, this.side, this.parent, this.line, this.range, this.inReplyTo, this.updated, this.message});
    }

    public static class Range
    implements Comparable<Range> {
        private static final Comparator<Range> RANGE_COMPARATOR = Comparator.comparingInt(range -> range.startLine).thenComparingInt(range -> range.startCharacter).thenComparingInt(range -> range.endLine).thenComparingInt(range -> range.endCharacter);
        public int startLine;
        public int startCharacter;
        public int endLine;
        public int endCharacter;

        public boolean isValid() {
            return this.startLine > 0 && this.startCharacter >= 0 && this.endLine > 0 && this.endCharacter >= 0 && this.startLine <= this.endLine && (this.startLine != this.endLine || this.startCharacter <= this.endCharacter);
        }

        public boolean equals(Object o) {
            if (o instanceof Range) {
                Range r = (Range)o;
                return Objects.equals(this.startLine, r.startLine) && Objects.equals(this.startCharacter, r.startCharacter) && Objects.equals(this.endLine, r.endLine) && Objects.equals(this.endCharacter, r.endCharacter);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.startLine, this.startCharacter, this.endLine, this.endCharacter);
        }

        public String toString() {
            return "Range{startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + '}';
        }

        @Override
        public int compareTo(Range otherRange) {
            return RANGE_COMPARATOR.compare(this, otherRange);
        }
    }
}

