/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.restapi;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public abstract class BinaryResult
implements Closeable {
    static final String OCTET_STREAM = "application/octet-stream";
    private String contentType = "application/octet-stream";
    private Charset characterEncoding;
    private long contentLength = -1L;
    private boolean gzip = true;
    private boolean base64;
    private String attachmentName;

    public static BinaryResult create(String data) {
        return new StringResult(data);
    }

    public static BinaryResult create(byte[] data) {
        return new Array(data);
    }

    public static BinaryResult create(InputStream data) {
        return new Stream(data);
    }

    public String getContentType() {
        Charset enc = this.getCharacterEncoding();
        if (enc != null) {
            return this.contentType + "; charset=" + enc.name();
        }
        return this.contentType;
    }

    public BinaryResult setContentType(String contentType) {
        this.contentType = contentType != null ? contentType : OCTET_STREAM;
        return this;
    }

    public Charset getCharacterEncoding() {
        return this.characterEncoding;
    }

    public BinaryResult setCharacterEncoding(Charset encoding) {
        this.characterEncoding = encoding;
        return this;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public BinaryResult setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
        return this;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public BinaryResult setContentLength(long len) {
        this.contentLength = len;
        return this;
    }

    public boolean canGzip() {
        return this.gzip;
    }

    public BinaryResult disableGzip() {
        this.gzip = false;
        return this;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public BinaryResult base64() {
        this.base64 = true;
        return this;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    public String asString() throws IOException {
        long len = this.getContentLength();
        ByteArrayOutputStream buf = 0L < len ? new ByteArrayOutputStream((int)len) : new ByteArrayOutputStream();
        this.writeTo(buf);
        return BinaryResult.decode(buf.toByteArray(), this.getCharacterEncoding());
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        if (this.getContentLength() >= 0L) {
            return String.format("BinaryResult[Content-Type: %s, Content-Length: %d]", this.getContentType(), this.getContentLength());
        }
        return String.format("BinaryResult[Content-Type: %s, Content-Length: unknown]", this.getContentType());
    }

    private static String decode(byte[] data, Charset enc) {
        try {
            Charset cs = enc != null ? enc : StandardCharsets.UTF_8;
            return cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(data)).toString();
        }
        catch (CharacterCodingException | UnsupportedCharsetException e) {
            StringBuilder r = new StringBuilder(data.length);
            for (byte b : data) {
                r.append((char)(b & 0xFF));
            }
            return r.toString();
        }
    }

    private static class Stream
    extends BinaryResult {
        private final InputStream src;

        Stream(InputStream src) {
            this.src = src;
        }

        @Override
        public void writeTo(OutputStream dst) throws IOException {
            int n;
            byte[] tmp = new byte[4096];
            while (0 < (n = this.src.read(tmp))) {
                dst.write(tmp, 0, n);
            }
        }

        @Override
        public void close() throws IOException {
            this.src.close();
        }
    }

    private static class StringResult
    extends Array {
        private final String str;

        StringResult(String str) {
            super(str.getBytes(StandardCharsets.UTF_8));
            this.setContentType("text/plain");
            this.setCharacterEncoding(StandardCharsets.UTF_8);
            this.str = str;
        }

        @Override
        public String asString() {
            return this.str;
        }
    }

    private static class Array
    extends BinaryResult {
        private final byte[] data;

        Array(byte[] data) {
            this.data = data;
            this.setContentLength(data.length);
        }

        @Override
        public void writeTo(OutputStream os) throws IOException {
            os.write(this.data);
        }

        @Override
        public String asString() {
            return BinaryResult.decode(this.data, this.getCharacterEncoding());
        }
    }
}

