/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest;

import com.google.common.base.Strings;

public interface GerritAuthData {
    public String getLogin();

    public String getPassword();

    public boolean isHttpPassword();

    public String getHost();

    public boolean isLoginAndPasswordAvailable();

    public static class Basic
    implements GerritAuthData {
        private final String host;
        private final String login;
        private final String password;
        private final boolean httpPassword;

        public Basic(String host) {
            this(host, "", "");
        }

        public Basic(String host, String login, String password) {
            this(host, login, password, false);
        }

        public Basic(String host, String login, String password, boolean httpPassword) {
            this.host = this.stripTrailingSlash(host);
            this.login = login;
            this.password = password;
            this.httpPassword = httpPassword;
        }

        @Override
        public boolean isHttpPassword() {
            return this.httpPassword;
        }

        @Override
        public String getLogin() {
            return this.login;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public boolean isLoginAndPasswordAvailable() {
            return !Strings.isNullOrEmpty((String)this.getLogin()) && !Strings.isNullOrEmpty((String)this.getPassword());
        }

        private String stripTrailingSlash(String host) {
            if (!Strings.isNullOrEmpty((String)host) && host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            return host;
        }
    }
}

