/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.urswolfer.gerrit.client.rest.GerritAuthData;
import com.urswolfer.gerrit.client.rest.RestClient;
import com.urswolfer.gerrit.client.rest.gson.GsonFactory;
import com.urswolfer.gerrit.client.rest.http.HttpClientBuilderExtension;
import com.urswolfer.gerrit.client.rest.http.HttpRequestExecutor;
import com.urswolfer.gerrit.client.rest.http.HttpStatusException;
import com.urswolfer.gerrit.client.rest.http.LoginCache;
import com.urswolfer.gerrit.client.rest.http.PreemptiveAuthHttpRequestInterceptor;
import com.urswolfer.gerrit.client.rest.http.UserAgentHttpRequestInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class GerritRestClient
implements RestClient {
    private static final String JSON_MIME_TYPE = ContentType.APPLICATION_JSON.getMimeType();
    private static final Pattern GERRIT_AUTH_PATTERN = Pattern.compile(".*?xGerritAuth=\"(.+?)\"");
    private static final int CONNECTION_TIMEOUT_MS = 300000;
    private static final Gson GSON = GsonFactory.create();
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setNormalizeUri(false).build();
    private final GerritAuthData authData;
    private final HttpRequestExecutor httpRequestExecutor;
    private final List<HttpClientBuilderExtension> httpClientBuilderExtensions;
    private final BasicCookieStore cookieStore;
    private final LoginCache loginCache;

    public GerritRestClient(GerritAuthData authData, HttpRequestExecutor httpRequestExecutor, HttpClientBuilderExtension ... httpClientBuilderExtensions) {
        this.authData = authData;
        this.httpRequestExecutor = httpRequestExecutor;
        this.httpClientBuilderExtensions = Arrays.asList(httpClientBuilderExtensions);
        this.cookieStore = new BasicCookieStore();
        this.loginCache = new LoginCache(authData, this.cookieStore);
    }

    @Override
    public Gson getGson() {
        return GSON;
    }

    @Override
    public JsonElement getRequest(String path) throws RestApiException {
        return this.requestJson(path, null, RestClient.HttpVerb.GET);
    }

    @Override
    public JsonElement postRequest(String path) throws RestApiException {
        return this.postRequest(path, null);
    }

    @Override
    public JsonElement postRequest(String path, String requestBody) throws RestApiException {
        return this.requestJson(path, requestBody, RestClient.HttpVerb.POST);
    }

    @Override
    public JsonElement putRequest(String path) throws RestApiException {
        return this.putRequest(path, null);
    }

    @Override
    public JsonElement putRequest(String path, String requestBody) throws RestApiException {
        return this.requestJson(path, requestBody, RestClient.HttpVerb.PUT);
    }

    @Override
    public JsonElement deleteRequest(String path) throws RestApiException {
        return this.requestJson(path, null, RestClient.HttpVerb.DELETE);
    }

    @Override
    public JsonElement requestJson(String path, String requestBody, RestClient.HttpVerb verb) throws RestApiException {
        try {
            HttpResponse response = this.requestRest(path, requestBody, verb);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            this.checkContentType(entity);
            JsonElement ret = this.parseResponse(entity.getContent());
            if (ret.isJsonNull()) {
                throw RestApiException.wrap("Unexpectedly empty response.", null);
            }
            return ret;
        }
        catch (IOException e) {
            throw RestApiException.wrap("Request failed.", e);
        }
    }

    @Override
    public HttpResponse requestRest(String path, String requestBody, RestClient.HttpVerb verb) throws IOException, HttpStatusException {
        return this.requestRest(path, requestBody, verb, false);
    }

    private HttpResponse requestRest(String path, String requestBody, RestClient.HttpVerb verb, boolean isRetry) throws IOException, HttpStatusException {
        BasicHeader acceptHeader = new BasicHeader("Accept", JSON_MIME_TYPE);
        return this.request(path, requestBody, verb, isRetry, new Header[]{acceptHeader});
    }

    @Override
    public HttpResponse request(String path, String requestBody, RestClient.HttpVerb verb, Header ... headers) throws IOException, HttpStatusException {
        return this.request(path, requestBody, verb, false, headers);
    }

    private HttpResponse request(String path, String requestBody, RestClient.HttpVerb verb, boolean isRetry, Header ... headers) throws IOException, HttpStatusException {
        HttpPost method;
        BasicHttpContext httpContext = new BasicHttpContext();
        HttpClientBuilder client = this.getHttpClient((HttpContext)httpContext);
        Optional<String> gerritAuthOptional = this.updateGerritAuthWhenRequired((HttpContext)httpContext, client);
        String uri = this.authData.getHost();
        if (this.authData.isLoginAndPasswordAvailable() && !gerritAuthOptional.isPresent()) {
            uri = uri + "/a";
        }
        uri = uri + path;
        switch (verb) {
            case POST: {
                method = new HttpPost(uri);
                this.setRequestBody(requestBody, (HttpRequestBase)method);
                break;
            }
            case POST_TEXT_PLAIN: {
                method = new HttpPost(uri);
                this.setRequestBody(requestBody, (HttpRequestBase)method, ContentType.TEXT_PLAIN);
                break;
            }
            case GET: {
                method = new HttpGet(uri);
                break;
            }
            case DELETE: {
                method = new HttpDelete(uri);
                break;
            }
            case PUT: {
                method = new HttpPut(uri);
                this.setRequestBody(requestBody, (HttpRequestBase)method);
                break;
            }
            case PUT_TEXT_PLAIN: {
                method = new HttpPut(uri);
                this.setRequestBody(requestBody, (HttpRequestBase)method, ContentType.TEXT_PLAIN);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown or unsupported HttpVerb method: " + verb.toString());
            }
        }
        if (gerritAuthOptional.isPresent()) {
            method.addHeader("X-Gerrit-Auth", (String)gerritAuthOptional.get());
        }
        for (Header header : headers) {
            method.addHeader(header);
        }
        method.setConfig(REQUEST_CONFIG);
        HttpResponse response = this.httpRequestExecutor.execute(client, (HttpRequestBase)method, (HttpContext)httpContext);
        if (!isRetry && response.getStatusLine().getStatusCode() == 403 && this.loginCache.getGerritAuthOptional().isPresent()) {
            this.loginCache.invalidate();
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            response = this.requestRest(path, requestBody, verb, true);
        }
        this.checkStatusCode(response);
        return response;
    }

    private void setRequestBody(String requestBody, HttpRequestBase method) {
        if (requestBody != null) {
            this.setRequestBody(requestBody, method, ContentType.APPLICATION_JSON);
        }
    }

    private void setRequestBody(String requestBody, HttpRequestBase method, ContentType contentType) {
        if (requestBody != null) {
            ((HttpEntityEnclosingRequestBase)method).setEntity((HttpEntity)new StringEntity(requestBody, contentType));
        }
    }

    private Optional<String> updateGerritAuthWhenRequired(HttpContext httpContext, HttpClientBuilder client) throws IOException, HttpStatusException {
        if (!this.loginCache.getHostSupportsGerritAuth()) {
            this.cookieStore.clear();
            return Optional.absent();
        }
        if (this.authData.isHttpPassword()) {
            return Optional.absent();
        }
        if (this.loginCache.isGithubOAuthDetected()) {
            return Optional.absent();
        }
        Optional<Cookie> gerritAccountCookie = this.findGerritAccountCookie();
        if (!gerritAccountCookie.isPresent() || ((Cookie)gerritAccountCookie.get()).isExpired(new Date()) || !this.isSessionValid(client, httpContext)) {
            return this.updateGerritAuth(httpContext, client);
        }
        return this.loginCache.getGerritAuthOptional();
    }

    private Optional<String> updateGerritAuth(HttpContext httpContext, HttpClientBuilder client) throws IOException, HttpStatusException {
        Optional gerritAuthOptional = this.tryGerritHttpAuth(client, httpContext).or(this.tryGerritHttpFormAuth(client, httpContext));
        this.loginCache.setGerritAuthOptional((Optional<String>)gerritAuthOptional);
        return gerritAuthOptional;
    }

    private Optional<String> tryGerritHttpFormAuth(HttpClientBuilder client, HttpContext httpContext) throws IOException, HttpStatusException {
        if (!this.authData.isLoginAndPasswordAvailable()) {
            return Optional.absent();
        }
        String loginUrl = this.authData.getHost() + "/login/";
        HttpPost method = new HttpPost(loginUrl);
        ArrayList parameters = Lists.newArrayList((Object[])new BasicNameValuePair[]{new BasicNameValuePair("username", this.authData.getLogin()), new BasicNameValuePair("password", this.authData.getPassword())});
        method.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)parameters, Consts.UTF_8));
        HttpResponse loginResponse = this.httpRequestExecutor.execute(client, (HttpRequestBase)method, httpContext);
        return this.extractGerritAuth(loginResponse, httpContext);
    }

    private Optional<String> tryGerritHttpAuth(HttpClientBuilder client, HttpContext httpContext) throws IOException, HttpStatusException {
        String loginUrl = this.authData.getHost() + "/login/";
        HttpResponse loginResponse = this.httpRequestExecutor.execute(client, (HttpRequestBase)new HttpGet(loginUrl), httpContext);
        return this.extractGerritAuth(loginResponse, httpContext);
    }

    private Optional<String> extractGerritAuth(HttpResponse loginResponse, HttpContext httpContext) throws IOException, HttpStatusException {
        this.checkStatusCodeServerError(loginResponse);
        if (!this.loginCache.isGitHubOAuthRequested(httpContext) && loginResponse.getStatusLine().getStatusCode() != 401) {
            return this.getXsrfCookie().or(this.getXsrfFromHtmlBody(loginResponse));
        }
        return Optional.absent();
    }

    private boolean isSessionValid(HttpClientBuilder client, HttpContext httpContext) throws IOException {
        String accountsSelfUrl = this.authData.getHost() + "/accounts/self";
        HttpResponse response = this.httpRequestExecutor.execute(client, (HttpRequestBase)new HttpGet(accountsSelfUrl), httpContext);
        return response.getStatusLine().getStatusCode() == 200;
    }

    private Optional<String> getXsrfCookie() {
        Optional<Cookie> xsrfCookie = this.findCookie("XSRF_TOKEN");
        if (xsrfCookie.isPresent()) {
            return Optional.of((Object)((Cookie)xsrfCookie.get()).getValue());
        }
        return Optional.absent();
    }

    private Optional<String> getXsrfFromHtmlBody(HttpResponse loginResponse) throws IOException {
        Matcher matcher;
        Optional<Cookie> gerritAccountCookie = this.findGerritAccountCookie();
        if (gerritAccountCookie.isPresent() && (matcher = GERRIT_AUTH_PATTERN.matcher(EntityUtils.toString((HttpEntity)loginResponse.getEntity(), (Charset)Consts.UTF_8))).find()) {
            return Optional.of((Object)matcher.group(1));
        }
        return Optional.absent();
    }

    private Optional<Cookie> findGerritAccountCookie() {
        return this.findCookie("GerritAccount");
    }

    private Optional<Cookie> findCookie(final String cookieName) {
        List cookies = this.cookieStore.getCookies();
        return Iterables.tryFind((Iterable)cookies, (Predicate)new Predicate<Cookie>(){

            public boolean apply(Cookie cookie) {
                return cookie.getName().equals(cookieName);
            }
        });
    }

    private HttpClientBuilder getHttpClient(HttpContext httpContext) {
        HttpClientBuilder client = HttpClients.custom();
        client.useSystemProperties();
        client.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        httpContext.setAttribute("http.cookie-store", (Object)this.cookieStore);
        RequestConfig.Builder requestConfig = RequestConfig.custom().setConnectTimeout(300000).setSocketTimeout(300000).setConnectionRequestTimeout(300000);
        client.setDefaultRequestConfig(requestConfig.build());
        BasicCredentialsProvider credentialsProvider = this.getCredentialsProvider();
        client.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (this.authData.isLoginAndPasswordAvailable()) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.authData.getLogin(), this.authData.getPassword()));
            BasicScheme basicAuth = new BasicScheme();
            httpContext.setAttribute("preemptive-auth", (Object)basicAuth);
            client.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthHttpRequestInterceptor(this.authData));
        }
        client.addInterceptorLast((HttpRequestInterceptor)new UserAgentHttpRequestInterceptor());
        for (HttpClientBuilderExtension httpClientBuilderExtension : this.httpClientBuilderExtensions) {
            client = httpClientBuilderExtension.extend(client, this.authData);
            credentialsProvider = httpClientBuilderExtension.extendCredentialProvider(client, (CredentialsProvider)credentialsProvider, this.authData);
        }
        return client;
    }

    private BasicCredentialsProvider getCredentialsProvider() {
        return new BasicCredentialsProvider(){
            private Set<AuthScope> authAlreadyTried = Sets.newHashSet();

            public Credentials getCredentials(AuthScope authscope) {
                if (this.authAlreadyTried.contains(authscope)) {
                    return null;
                }
                this.authAlreadyTried.add(authscope);
                return super.getCredentials(authscope);
            }
        };
    }

    private JsonElement parseResponse(InputStream response) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(response, Consts.UTF_8);){
            JsonElement jsonElement = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
    }

    private void checkStatusCode(HttpResponse response) throws HttpStatusException, IOException {
        this.checkStatusCodeClientError(response);
        this.checkStatusCodeServerError(response);
    }

    private void checkStatusCodeClientError(HttpResponse response) throws HttpStatusException, IOException {
        this.checkStatusCodeError(response, 400, 499);
    }

    private void checkStatusCodeServerError(HttpResponse response) throws HttpStatusException, IOException {
        this.checkStatusCodeError(response, 500, 599);
    }

    private void checkStatusCodeError(HttpResponse response, int errorIfMin, int errorIfMax) throws HttpStatusException, IOException {
        StatusLine statusLine = response.getStatusLine();
        int code = statusLine.getStatusCode();
        if (code >= errorIfMin && code <= errorIfMax) {
            this.throwHttpStatusException(response);
        }
    }

    private void throwHttpStatusException(HttpResponse response) throws IOException, HttpStatusException {
        StatusLine statusLine = response.getStatusLine();
        String body = "<empty>";
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toString((HttpEntity)entity).trim();
        }
        String message = String.format("Request not successful. Message: %s. Status-Code: %s. Content:%n%s.", statusLine.getReasonPhrase(), statusLine.getStatusCode(), body);
        throw new HttpStatusException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), message);
    }

    private void checkContentType(HttpEntity entity) throws RestApiException, IOException {
        Header contentType = entity.getContentType();
        if (contentType != null && !contentType.getValue().contains(JSON_MIME_TYPE)) {
            throw RestApiException.wrap(String.format("Expected JSON but got '%s'. Content:%n%s", contentType.getValue(), EntityUtils.toString((HttpEntity)entity).trim()), null);
        }
    }
}

