/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http;

import com.google.common.base.Optional;
import com.urswolfer.gerrit.client.rest.GerritAuthData;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.HttpContext;

public class LoginCache {
    private final BasicCookieStore cookieStore;
    private final GerritAuthData authData;
    private boolean githubOAuthDetected;
    private Optional<String> gerritAuthOptional = Optional.absent();
    private boolean hostSupportsGerritAuth = true;
    private String lastConnection;

    public LoginCache(GerritAuthData authData, BasicCookieStore cookieStore) {
        this.authData = authData;
        this.cookieStore = cookieStore;
    }

    public void setGerritAuthOptional(Optional<String> gerritAuthOptional) {
        this.gerritAuthOptional = gerritAuthOptional;
        this.hostSupportsGerritAuth = gerritAuthOptional.isPresent();
    }

    public Optional<String> getGerritAuthOptional() {
        this.invalidateLoginDataOnNewSettings();
        return this.gerritAuthOptional;
    }

    public boolean getHostSupportsGerritAuth() {
        this.invalidateLoginDataOnNewSettings();
        return this.hostSupportsGerritAuth;
    }

    public void invalidate() {
        this.lastConnection = null;
        this.gerritAuthOptional = Optional.absent();
        this.hostSupportsGerritAuth = true;
        this.cookieStore.clear();
    }

    public boolean isGithubOAuthDetected() {
        return this.githubOAuthDetected;
    }

    public boolean isGitHubOAuthRequested(HttpContext loginContext) {
        HttpUriRequest lastRequest = (HttpUriRequest)loginContext.getAttribute("http.request");
        return this.githubOAuthDetected || (this.githubOAuthDetected = lastRequest != null && lastRequest.getURI().getPath().contains("github-plugin"));
    }

    private void invalidateLoginDataOnNewSettings() {
        String authDataString = "" + this.authData.getHost() + this.authData.getLogin() + this.authData.getPassword();
        if (!authDataString.equals(this.lastConnection)) {
            this.invalidate();
            this.lastConnection = authDataString;
        }
    }
}

