/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http;

import com.urswolfer.gerrit.client.rest.GerritAuthData;
import java.net.URI;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;

class PreemptiveAuthHttpRequestInterceptor
implements HttpRequestInterceptor {
    static final String PREEMPTIVE_AUTH = "preemptive-auth";
    private GerritAuthData authData;

    PreemptiveAuthHttpRequestInterceptor(GerritAuthData authData) {
        this.authData = authData;
    }

    public void process(HttpRequest request, HttpContext context) {
        if (!this.isForGerritHost(request)) {
            return;
        }
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState.getAuthScheme() == null) {
            AuthScheme authScheme = (AuthScheme)context.getAttribute(PREEMPTIVE_AUTH);
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.authData.getLogin(), this.authData.getPassword());
            authState.update(authScheme, (Credentials)creds);
        }
    }

    private boolean isForGerritHost(HttpRequest request) {
        if (!(request instanceof HttpRequestWrapper)) {
            return false;
        }
        HttpRequest originalRequest = ((HttpRequestWrapper)request).getOriginal();
        if (!(originalRequest instanceof HttpRequestBase)) {
            return false;
        }
        URI uri = ((HttpRequestBase)originalRequest).getURI();
        URI authDataUri = URI.create(this.authData.getHost());
        if (uri == null || uri.getHost() == null) {
            return false;
        }
        boolean hostEquals = uri.getHost().equals(authDataUri.getHost());
        boolean portEquals = uri.getPort() == authDataUri.getPort();
        return hostEquals && portEquals;
    }
}

