/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.accounts;

import com.google.gerrit.extensions.api.accounts.AccountApi;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.SshKeyInfo;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.RestClient;
import com.urswolfer.gerrit.client.rest.accounts.AccountApi;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.accounts.AccountsParser;
import com.urswolfer.gerrit.client.rest.http.accounts.SshKeysParser;
import com.urswolfer.gerrit.client.rest.http.util.BinaryResultUtils;
import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class AccountApiRestClient
extends AccountApi.NotImplemented
implements AccountApi {
    private final AccountsParser accountsParser;
    private final SshKeysParser sshKeysParser;
    private final GerritRestClient gerritRestClient;
    private final String name;

    public AccountApiRestClient(GerritRestClient gerritRestClient, AccountsParser accountsParser, SshKeysParser sshKeysParser, String name) {
        this.gerritRestClient = gerritRestClient;
        this.accountsParser = accountsParser;
        this.sshKeysParser = sshKeysParser;
        this.name = name;
    }

    @Override
    public AccountInfo get() throws RestApiException {
        JsonElement result = this.gerritRestClient.getRequest(this.getRequestPath());
        return this.accountsParser.parseAccountInfo(result);
    }

    @Override
    public void starChange(String id) throws RestApiException {
        this.gerritRestClient.putRequest(this.createStarUrl(id));
    }

    @Override
    public void unstarChange(String id) throws RestApiException {
        this.gerritRestClient.deleteRequest(this.createStarUrl(id));
    }

    private String createStarUrl(String id) {
        return this.getRequestPath() + "/starred.changes/" + id;
    }

    @Override
    public BinaryResult downloadAvatar(int size) throws RestApiException {
        String request = this.getRequestPath() + "/avatar?s=" + size;
        try {
            HttpResponse response = this.gerritRestClient.request(request, null, RestClient.HttpVerb.GET, new Header[0]);
            return BinaryResultUtils.createBinaryResult(response);
        }
        catch (IOException e) {
            throw RestApiException.wrap("Failed to get avatar.", e);
        }
    }

    private String getRequestPath() {
        return "/accounts/" + Url.encode(this.name);
    }

    @Override
    public SshKeyInfo addSshKey(String key) throws RestApiException {
        String request = this.getRequestPath() + "/sshkeys";
        JsonElement result = this.gerritRestClient.requestJson(request, key, RestClient.HttpVerb.POST_TEXT_PLAIN);
        return this.sshKeysParser.parseSshKeyInfo(result);
    }

    @Override
    public List<SshKeyInfo> listSshKeys() throws RestApiException {
        String request = this.getRequestPath() + "/sshkeys";
        JsonElement result = this.gerritRestClient.getRequest(request);
        return this.sshKeysParser.parseSshKeyInfos(result);
    }

    @Override
    public void deleteSshKey(int seq) throws RestApiException {
        String request = this.getRequestPath() + "/sshkeys/" + seq;
        this.gerritRestClient.deleteRequest(request);
    }
}

