/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.accounts;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class AccountsParser {
    private static final Type TYPE = new TypeToken<List<AccountInfo>>(){}.getType();
    private final Gson gson;

    public AccountsParser(Gson gson) {
        this.gson = gson;
    }

    public AccountInfo parseAccountInfo(JsonElement result) {
        return (AccountInfo)this.gson.fromJson(result, AccountInfo.class);
    }

    public List<AccountInfo> parseAccountInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.parseAccountInfo(result));
        }
        return (List)this.gson.fromJson(result, TYPE);
    }
}

