/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.accounts;

import com.google.gerrit.extensions.api.accounts.Accounts;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.accounts.AccountApi;
import com.urswolfer.gerrit.client.rest.accounts.Accounts;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.accounts.AccountApiRestClient;
import com.urswolfer.gerrit.client.rest.http.accounts.AccountsParser;
import com.urswolfer.gerrit.client.rest.http.accounts.SshKeysParser;
import java.util.List;

public class AccountsRestClient
extends Accounts.NotImplemented
implements Accounts {
    private final GerritRestClient gerritRestClient;
    private final AccountsParser accountsParser;
    private final SshKeysParser sshKeysParser;

    public AccountsRestClient(GerritRestClient gerritRestClient, AccountsParser accountsParser, SshKeysParser sshKeysParser) {
        this.gerritRestClient = gerritRestClient;
        this.accountsParser = accountsParser;
        this.sshKeysParser = sshKeysParser;
    }

    @Override
    public AccountApi id(String id) throws RestApiException {
        return new AccountApiRestClient(this.gerritRestClient, this.accountsParser, this.sshKeysParser, id);
    }

    @Override
    public AccountApi id(int id) throws RestApiException {
        return this.id(String.valueOf(id));
    }

    @Override
    public AccountApi self() throws RestApiException {
        return this.id("self");
    }

    @Override
    public Accounts.SuggestAccountsRequest suggestAccounts() throws RestApiException {
        return new Accounts.SuggestAccountsRequest(){

            @Override
            public List<AccountInfo> get() throws RestApiException {
                return AccountsRestClient.this.suggestAccounts(this);
            }
        };
    }

    @Override
    public Accounts.SuggestAccountsRequest suggestAccounts(String query) throws RestApiException {
        return this.suggestAccounts().withQuery(query);
    }

    private List<AccountInfo> suggestAccounts(Accounts.SuggestAccountsRequest r) throws RestApiException {
        String encodedQuery = Url.encode(r.getQuery());
        return this.getSuggestAccounts(String.format("q=%s&n=%s", encodedQuery, r.getLimit()));
    }

    private List<AccountInfo> getSuggestAccounts(String queryPart) throws RestApiException {
        String request = String.format("/accounts/?suggest&%s", queryPart);
        JsonElement suggestedReviewers = this.gerritRestClient.getRequest(request);
        return this.accountsParser.parseAccountInfos(suggestedReviewers);
    }
}

