/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AddReviewerResult;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.ChangeEditApi;
import com.google.gerrit.extensions.api.changes.FixInput;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.api.changes.MoveInput;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeMessageInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.CommitMessageInput;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.common.RevertSubmissionInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.accounts.AccountsParser;
import com.urswolfer.gerrit.client.rest.http.changes.ChangeEditApiRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.ChangesRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.ListChangesOptionByVersion;
import com.urswolfer.gerrit.client.rest.http.changes.RevisionApiRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.ChangeInfosParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.CommentsParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.CommitInfosParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.FileInfoParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.MergeableInfoParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.ReviewInfoParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.ReviewResultParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.ReviewerInfosParser;
import com.urswolfer.gerrit.client.rest.http.config.ServerRestClient;
import com.urswolfer.gerrit.client.rest.http.util.UrlUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChangeApiRestClient
extends ChangeApi.NotImplemented
implements ChangeApi {
    private final GerritRestClient gerritRestClient;
    private final ChangesRestClient changesRestClient;
    private final ChangeInfosParser changeInfosParser;
    private final CommentsParser commentsParser;
    private final FileInfoParser fileInfoParser;
    private final ReviewResultParser reviewResultParser;
    private final ReviewerInfosParser reviewerInfosParser;
    private final CommitInfosParser commitInfosParser;
    private final AccountsParser accountsParser;
    private final MergeableInfoParser mergeableInfoParser;
    private final ReviewInfoParser reviewInfoParser;
    private final String id;
    private final ServerRestClient serverRestClient;

    public ChangeApiRestClient(GerritRestClient gerritRestClient, ChangesRestClient changesRestClient, ChangeInfosParser changeInfosParser, CommentsParser commentsParser, FileInfoParser fileInfoParser, ReviewResultParser reviewResultParser, ReviewerInfosParser reviewerInfosParser, CommitInfosParser commitInfosParser, AccountsParser accountsParser, MergeableInfoParser mergeableInfoParser, ReviewInfoParser reviewInfoParser, String id) {
        this.gerritRestClient = gerritRestClient;
        this.changesRestClient = changesRestClient;
        this.changeInfosParser = changeInfosParser;
        this.commentsParser = commentsParser;
        this.fileInfoParser = fileInfoParser;
        this.reviewResultParser = reviewResultParser;
        this.reviewerInfosParser = reviewerInfosParser;
        this.commitInfosParser = commitInfosParser;
        this.accountsParser = accountsParser;
        this.mergeableInfoParser = mergeableInfoParser;
        this.reviewInfoParser = reviewInfoParser;
        this.id = id;
        this.serverRestClient = new ServerRestClient(gerritRestClient);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public RevisionApi current() throws RestApiException {
        return this.revision("current");
    }

    @Override
    public RevisionApi revision(int id) throws RestApiException {
        return this.revision(Integer.toString(id));
    }

    @Override
    public RevisionApi revision(String id) throws RestApiException {
        return new RevisionApiRestClient(this.gerritRestClient, this, this.commentsParser, this.fileInfoParser, this.reviewResultParser, this.commitInfosParser, this.mergeableInfoParser, this.reviewInfoParser, id);
    }

    @Override
    public void abandon() throws RestApiException {
        this.abandon(new AbandonInput());
    }

    @Override
    public void abandon(AbandonInput abandonInput) throws RestApiException {
        String request = this.getRequestPath() + "/abandon";
        String json = this.gerritRestClient.getGson().toJson((Object)abandonInput);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public void restore() throws RestApiException {
        this.restore(new RestoreInput());
    }

    @Override
    public void restore(RestoreInput restoreInput) throws RestApiException {
        String request = this.getRequestPath() + "/restore";
        String json = this.gerritRestClient.getGson().toJson((Object)restoreInput);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public void move(String destinationBranch) throws RestApiException {
        MoveInput moveInput = new MoveInput();
        moveInput.destinationBranch = destinationBranch;
        this.move(moveInput);
    }

    @Override
    public void move(MoveInput moveInput) throws RestApiException {
        String request = this.getRequestPath() + "/move";
        String json = this.gerritRestClient.getGson().toJson((Object)moveInput);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public ChangeApi revert() throws RestApiException {
        return this.revert(new RevertInput());
    }

    @Override
    public ChangeApi revert(RevertInput revertInput) throws RestApiException {
        String request = this.getRequestPath() + "/revert";
        String json = this.gerritRestClient.getGson().toJson((Object)revertInput);
        ChangeInfo newChangeInfo = this.changeInfosParser.parseSingleChangeInfo(this.gerritRestClient.postRequest(request, json));
        return new ChangeApiRestClient(this.gerritRestClient, this.changesRestClient, this.changeInfosParser, this.commentsParser, this.fileInfoParser, this.reviewResultParser, this.reviewerInfosParser, this.commitInfosParser, this.accountsParser, this.mergeableInfoParser, this.reviewInfoParser, newChangeInfo.id);
    }

    @Override
    public RevertSubmissionInfo revertSubmission() throws RestApiException {
        return this.revertSubmission(new RevertInput());
    }

    @Override
    public RevertSubmissionInfo revertSubmission(RevertInput in) throws RestApiException {
        String request = this.getRequestPath() + "/revert_submission";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        JsonElement revertedChanges = this.gerritRestClient.postRequest(request, json);
        RevertSubmissionInfo revertSubmissionInfo = new RevertSubmissionInfo();
        revertSubmissionInfo.revertChanges = this.changeInfosParser.parseChangeInfos(revertedChanges);
        return revertSubmissionInfo;
    }

    @Override
    public void publish() throws RestApiException {
        String request = this.getRequestPath() + "/publish";
        this.gerritRestClient.postRequest(request);
    }

    @Override
    public void delete() throws RestApiException {
        String request = this.getRequestPath();
        this.gerritRestClient.deleteRequest(request);
    }

    @Override
    public String topic() throws RestApiException {
        String request = this.getRequestPath() + "/topic";
        return this.gerritRestClient.getRequest(request).getAsString();
    }

    @Override
    public void topic(String topic) throws RestApiException {
        String request = this.getRequestPath() + "/topic";
        Map<String, String> topicInput = Collections.singletonMap("topic", topic);
        String json = this.gerritRestClient.getGson().toJson(topicInput);
        this.gerritRestClient.putRequest(request, json);
    }

    @Override
    public IncludedInInfo includedIn() throws RestApiException {
        String request = this.getRequestPath() + "/in";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.changeInfosParser.parseIncludedInInfos(jsonElement);
    }

    @Override
    @Deprecated
    public List<ReviewerInfo> listReviewers() throws RestApiException {
        return this.reviewers();
    }

    @Override
    public List<ReviewerInfo> reviewers() throws RestApiException {
        String request = this.getRequestPath() + "/reviewers";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.reviewerInfosParser.parseReviewerInfos(jsonElement);
    }

    @Override
    public AddReviewerResult addReviewer(AddReviewerInput in) throws RestApiException {
        String request = this.getRequestPath() + "/reviewers";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        JsonElement reviewerResult = this.gerritRestClient.postRequest(request, json);
        return this.reviewerInfosParser.parseAddReviewerResult(reviewerResult);
    }

    @Override
    public AddReviewerResult addReviewer(String in) throws RestApiException {
        AddReviewerInput input = new AddReviewerInput();
        input.reviewer = in;
        return this.addReviewer(input);
    }

    @Override
    public ChangeApi.SuggestedReviewersRequest suggestReviewers() throws RestApiException {
        return new ChangeApi.SuggestedReviewersRequest(){

            @Override
            public List<SuggestedReviewerInfo> get() throws RestApiException {
                return ChangeApiRestClient.this.suggestReviewers(this);
            }
        };
    }

    @Override
    public ChangeApi.SuggestedReviewersRequest suggestReviewers(String query) throws RestApiException {
        return this.suggestReviewers().withQuery(query).withLimit(-1);
    }

    private List<SuggestedReviewerInfo> suggestReviewers(ChangeApi.SuggestedReviewersRequest r) throws RestApiException {
        String encodedQuery = Url.encode(r.getQuery());
        return this.getSuggestedReviewers(String.format("q=%s&n=%s", encodedQuery, r.getLimit()));
    }

    private List<SuggestedReviewerInfo> getSuggestedReviewers(String queryPart) throws RestApiException {
        String request = this.getRequestPath() + String.format("/suggest_reviewers?%s", queryPart);
        JsonElement suggestedReviewers = this.gerritRestClient.getRequest(request);
        return this.reviewerInfosParser.parseSuggestReviewerInfos(suggestedReviewers);
    }

    @Override
    public ChangeInfo get(EnumSet<ListChangesOption> options) throws RestApiException {
        String query = "";
        for (ListChangesOption option : options) {
            query = UrlUtils.appendToUrlQuery(query, "o=" + option);
        }
        String url = this.getRequestPath();
        if (!Strings.isNullOrEmpty((String)query)) {
            url = url + '?' + query;
        }
        JsonElement jsonElement = this.gerritRestClient.getRequest(url);
        return this.changeInfosParser.parseSingleChangeInfo(jsonElement);
    }

    @Override
    public ChangeInfo get() throws RestApiException {
        return this.get(ListChangesOptionByVersion.allSupported(this.serverRestClient.getVersionCached()));
    }

    @Override
    public ChangeInfo info() throws RestApiException {
        return this.get(EnumSet.noneOf(ListChangesOption.class));
    }

    @Override
    public EditInfo getEdit() throws RestApiException {
        String request = this.getRequestPath() + "/edit";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return (EditInfo)Iterables.getOnlyElement(this.commitInfosParser.parseEditInfos(jsonElement));
    }

    @Override
    public ChangeEditApi edit() throws RestApiException {
        return new ChangeEditApiRestClient(this.gerritRestClient, this.id);
    }

    @Override
    public void setMessage(String message) throws RestApiException {
        CommitMessageInput commitMessageInput = new CommitMessageInput();
        commitMessageInput.message = message;
        this.setMessage(commitMessageInput);
    }

    @Override
    public void setMessage(CommitMessageInput in) throws RestApiException {
        String request = this.getRequestPath() + "/message";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public void setHashtags(HashtagsInput input) throws RestApiException {
        String request = this.getRequestPath() + "/hashtags";
        String json = this.gerritRestClient.getGson().toJson((Object)input);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public Set<String> getHashtags() throws RestApiException {
        String request = this.getRequestPath() + "/hashtags";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.changeInfosParser.parseHashtags(jsonElement);
    }

    @Override
    public AccountInfo getAssignee() throws RestApiException {
        String request = this.getRequestPath() + "/assignee";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.accountsParser.parseAccountInfo(jsonElement);
    }

    @Override
    public List<AccountInfo> getPastAssignees() throws RestApiException {
        String request = this.getRequestPath() + "/past_assignees";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.accountsParser.parseAccountInfos(jsonElement);
    }

    @Override
    public ChangeInfo check() throws RestApiException {
        String request = this.getRequestPath() + "/check";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.changeInfosParser.parseSingleChangeInfo(jsonElement);
    }

    @Override
    public ChangeInfo check(FixInput in) throws RestApiException {
        String request = this.getRequestPath() + "/check";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        JsonElement jsonElement = this.gerritRestClient.postRequest(request, json);
        return this.changeInfosParser.parseSingleChangeInfo(jsonElement);
    }

    @Override
    public Map<String, List<CommentInfo>> comments() throws RestApiException {
        String request = this.getRequestPath() + "/comments";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseCommentInfos(jsonElement);
    }

    @Override
    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
        String request = this.getRequestPath() + "/robotcomments";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseRobotCommentInfos(jsonElement);
    }

    @Override
    public Map<String, List<CommentInfo>> drafts() throws RestApiException {
        String request = this.getRequestPath() + "/drafts";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseCommentInfos(jsonElement);
    }

    @Override
    public void index() throws RestApiException {
        String request = this.getRequestPath() + "/index";
        this.gerritRestClient.postRequest(request);
    }

    @Override
    public List<ChangeInfo> submittedTogether() throws RestApiException {
        String url = this.getRequestPath() + "/submitted_together";
        JsonElement jsonElement = this.gerritRestClient.getRequest(url);
        return this.changeInfosParser.parseChangeInfos(jsonElement);
    }

    @Override
    public List<ChangeMessageInfo> messages() throws RestApiException {
        String request = this.getRequestPath() + "/messages";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseChangeMessageInfos(jsonElement);
    }

    @Override
    public void ignore(boolean ignore) throws RestApiException {
        String path = ignore ? "/ignore" : "/unignore";
        String request = this.getRequestPath() + path;
        this.gerritRestClient.putRequest(request);
    }

    @Override
    public void rebase(RebaseInput in) throws RestApiException {
        String url = this.getRequestPath() + "/rebase";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        this.gerritRestClient.postRequest(url, json);
    }

    protected String getRequestPath() {
        return "/changes/" + this.id;
    }
}

