/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes;

import com.google.gerrit.extensions.api.changes.ChangeEditApi;
import com.google.gerrit.extensions.api.changes.FileContentInput;
import com.google.gerrit.extensions.api.changes.PublishChangeEditInput;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.urswolfer.gerrit.client.rest.RestClient;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.util.BinaryResultUtils;
import java.io.IOException;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ChangeEditApiRestClient
extends ChangeEditApi.NotImplemented
implements ChangeEditApi {
    private final GerritRestClient gerritRestClient;
    private final String id;

    public ChangeEditApiRestClient(GerritRestClient gerritRestClient, String id) {
        this.gerritRestClient = gerritRestClient;
        this.id = id;
    }

    @Override
    public Optional<BinaryResult> getFile(String filePath) throws RestApiException {
        String request = this.getRequestPath() + "/" + filePath;
        try {
            HttpResponse response = this.gerritRestClient.request(request, null, RestClient.HttpVerb.GET, new Header[0]);
            return Optional.of(BinaryResultUtils.createBinaryResult(response));
        }
        catch (IOException e) {
            throw RestApiException.wrap("Failed to get file content.", e);
        }
    }

    @Override
    public void modifyFile(String filePath, FileContentInput input) throws RestApiException {
        String request = this.getRequestPath() + "/" + filePath;
        try {
            this.gerritRestClient.request(request, input.binary_content, RestClient.HttpVerb.PUT_TEXT_PLAIN, new Header[0]);
        }
        catch (IOException e) {
            throw RestApiException.wrap("Failed to modify file.", e);
        }
    }

    @Override
    public void publish(PublishChangeEditInput input) throws RestApiException {
        String request = this.getRequestPath() + ":publish";
        String json = this.gerritRestClient.getGson().toJson((Object)input);
        this.gerritRestClient.postRequest(request, json);
    }

    protected String getRequestPath() {
        return "/changes/" + this.id + "/edit";
    }
}

