/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gerrit.extensions.api.changes.FileApi;
import com.google.gerrit.extensions.common.DiffInfo;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.RestClient;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.RevisionApiRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.CommitInfosParser;
import com.urswolfer.gerrit.client.rest.http.util.BinaryResultUtils;
import com.urswolfer.gerrit.client.rest.http.util.UrlUtils;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class FileApiRestClient
extends FileApi.NotImplemented {
    private final GerritRestClient gerritRestClient;
    private final RevisionApiRestClient revisionApiRestClient;
    private final CommitInfosParser commitInfosParser;
    private final String path;
    private final java.util.function.Supplier<String> requestPath = Suppliers.memoize((Supplier)new Supplier<String>(){

        public String get() {
            String encodedPath = Url.encode(FileApiRestClient.this.path);
            return FileApiRestClient.this.revisionApiRestClient.getRequestPath() + "/files/" + encodedPath;
        }
    });

    public FileApiRestClient(GerritRestClient gerritRestClient, RevisionApiRestClient revisionApiRestClient, CommitInfosParser commitInfosParser, String path) {
        this.gerritRestClient = gerritRestClient;
        this.revisionApiRestClient = revisionApiRestClient;
        this.commitInfosParser = commitInfosParser;
        this.path = path;
    }

    @Override
    public BinaryResult content() throws RestApiException {
        String request = this.getRequestPath() + "/content";
        try {
            HttpResponse response = this.gerritRestClient.request(request, null, RestClient.HttpVerb.GET, new Header[0]);
            return BinaryResultUtils.createBinaryResult(response);
        }
        catch (IOException e) {
            throw RestApiException.wrap("Failed to get file content.", e);
        }
    }

    @Override
    public DiffInfo diff() throws RestApiException {
        return this.diffRequest().get();
    }

    @Override
    public DiffInfo diff(String base) throws RestApiException {
        return this.diffRequest().withBase(base).get();
    }

    @Override
    public DiffInfo diff(int parent) throws RestApiException {
        return this.diff(this.diffRequest(), parent);
    }

    @Override
    public FileApi.DiffRequest diffRequest() throws RestApiException {
        return new FileApi.DiffRequest(){

            @Override
            public DiffInfo get() throws RestApiException {
                return FileApiRestClient.this.diff(this);
            }
        };
    }

    private DiffInfo diff(FileApi.DiffRequest diffRequest) throws RestApiException {
        return this.diff(diffRequest, 0);
    }

    private DiffInfo diff(FileApi.DiffRequest diffRequest, int parent) throws RestApiException {
        String query = "";
        if (!Strings.isNullOrEmpty((String)diffRequest.getBase())) {
            query = UrlUtils.appendToUrlQuery(query, "base=" + diffRequest.getBase());
        }
        if (diffRequest.getContext() != null) {
            query = UrlUtils.appendToUrlQuery(query, "context=" + diffRequest.getContext());
        }
        if (diffRequest.getIntraline() != null) {
            query = UrlUtils.appendToUrlQuery(query, "intraline=" + diffRequest.getIntraline());
        }
        if (diffRequest.getWhitespace() != null) {
            query = UrlUtils.appendToUrlQuery(query, "whitespace=" + (Object)((Object)diffRequest.getWhitespace()));
        }
        if (parent > 0) {
            query = UrlUtils.appendToUrlQuery(query, "parent=" + parent);
        }
        String url = this.getRequestPath() + "/diff";
        if (!Strings.isNullOrEmpty((String)query)) {
            url = url + '?' + query;
        }
        JsonElement jsonElement = this.gerritRestClient.getRequest(url);
        return this.commitInfosParser.parseDiffInfo(jsonElement);
    }

    protected String getRequestPath() {
        return this.requestPath.get();
    }
}

