/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes;

import com.google.gerrit.extensions.client.ListChangesOption;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ListChangesOptionByVersion {
    static final Map<String, ListChangesOption> MAX_CHANGE_OPTION_BY_VERSION = new HashMap<String, ListChangesOption>();
    static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\..*");

    ListChangesOptionByVersion() {
    }

    private static void put(String version, ListChangesOption maxOption) {
        MAX_CHANGE_OPTION_BY_VERSION.put(version, maxOption);
    }

    static boolean isSupportedOnVersion(ListChangesOption listChangesOption, String gerritVersion) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(gerritVersion);
        if (!versionMatcher.matches()) {
            return true;
        }
        ListChangesOption maxOption = MAX_CHANGE_OPTION_BY_VERSION.get(versionMatcher.group(1) + "." + versionMatcher.group(2));
        if (maxOption == null) {
            return true;
        }
        return listChangesOption.getValue() <= maxOption.getValue();
    }

    static EnumSet<ListChangesOption> allSupported(String gerritVersion) {
        EnumSet<ListChangesOption> changesOptions = EnumSet.noneOf(ListChangesOption.class);
        for (ListChangesOption option : EnumSet.allOf(ListChangesOption.class)) {
            if (!ListChangesOptionByVersion.isSupportedOnVersion(option, gerritVersion) || option == ListChangesOption.CHECK) continue;
            changesOptions.add(option);
        }
        return changesOptions;
    }

    static {
        ListChangesOptionByVersion.put("2.6", ListChangesOption.DETAILED_ACCOUNTS);
        ListChangesOptionByVersion.put("2.7", ListChangesOption.MESSAGES);
        ListChangesOptionByVersion.put("2.8", ListChangesOption.DOWNLOAD_COMMANDS);
        ListChangesOptionByVersion.put("2.9", ListChangesOption.DOWNLOAD_COMMANDS);
        ListChangesOptionByVersion.put("2.10", ListChangesOption.WEB_LINKS);
        ListChangesOptionByVersion.put("2.11", ListChangesOption.CHANGE_ACTIONS);
        ListChangesOptionByVersion.put("2.12", ListChangesOption.PUSH_CERTIFICATES);
        ListChangesOptionByVersion.put("2.13", ListChangesOption.REVIEWER_UPDATES);
        ListChangesOptionByVersion.put("2.14", ListChangesOption.SUBMITTABLE);
        ListChangesOptionByVersion.put("2.15", ListChangesOption.TRACKING_IDS);
        ListChangesOptionByVersion.put("2.16", ListChangesOption.SKIP_MERGEABLE);
    }
}

