/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.api.changes.DraftApi;
import com.google.gerrit.extensions.api.changes.DraftInput;
import com.google.gerrit.extensions.api.changes.FileApi;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.ReviewResult;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.FileInfo;
import com.google.gerrit.extensions.common.MergeableInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.common.TestSubmitRuleInput;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.urswolfer.gerrit.client.rest.RestClient;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.ChangeApiRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.DraftApiRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.FileApiRestClient;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.CommentsParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.CommitInfosParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.FileInfoParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.MergeableInfoParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.ReviewInfoParser;
import com.urswolfer.gerrit.client.rest.http.changes.parsers.ReviewResultParser;
import com.urswolfer.gerrit.client.rest.http.util.BinaryResultUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class RevisionApiRestClient
extends RevisionApi.NotImplemented
implements RevisionApi {
    private final GerritRestClient gerritRestClient;
    private final ChangeApiRestClient changeApiRestClient;
    private final CommentsParser commentsParser;
    private final FileInfoParser fileInfoParser;
    private final ReviewResultParser reviewResultParser;
    private final CommitInfosParser commitInfosParser;
    private final MergeableInfoParser mergeableInfoParser;
    private final ReviewInfoParser reviewInfoParser;
    private final String revision;

    public RevisionApiRestClient(GerritRestClient gerritRestClient, ChangeApiRestClient changeApiRestClient, CommentsParser commentsParser, FileInfoParser fileInfoParser, ReviewResultParser reviewResultParser, CommitInfosParser commitInfosParser, MergeableInfoParser mergeableInfoParser, ReviewInfoParser reviewInfoParser, String revision) {
        this.gerritRestClient = gerritRestClient;
        this.changeApiRestClient = changeApiRestClient;
        this.commentsParser = commentsParser;
        this.fileInfoParser = fileInfoParser;
        this.reviewResultParser = reviewResultParser;
        this.commitInfosParser = commitInfosParser;
        this.mergeableInfoParser = mergeableInfoParser;
        this.reviewInfoParser = reviewInfoParser;
        this.revision = revision;
    }

    public String revision() {
        return this.revision;
    }

    @Override
    public void delete() throws RestApiException {
        String request = this.getRequestPath();
        this.gerritRestClient.deleteRequest(request);
    }

    @Override
    public ReviewResult review(ReviewInput reviewInput) throws RestApiException {
        String request = this.getRequestPath() + "/review";
        String json = this.gerritRestClient.getGson().toJson((Object)reviewInput);
        JsonElement reviewResult = this.gerritRestClient.postRequest(request, json);
        return this.reviewResultParser.parseReviewResult(reviewResult);
    }

    @Override
    public void submit() throws RestApiException {
        this.submit(new SubmitInput());
    }

    @Override
    public void submit(SubmitInput submitInput) throws RestApiException {
        String request = this.changeApiRestClient.getRequestPath() + "/submit";
        String json = this.gerritRestClient.getGson().toJson((Object)submitInput);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public void publish() throws RestApiException {
        String request = this.getRequestPath() + "/publish";
        this.gerritRestClient.postRequest(request);
    }

    @Override
    public ChangeApi cherryPick(CherryPickInput in) throws RestApiException {
        String request = this.getRequestPath() + "/cherrypick";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        this.gerritRestClient.postRequest(request, json);
        return this.changeApiRestClient;
    }

    @Override
    public ChangeApi rebase() throws RestApiException {
        return this.rebase(new RebaseInput());
    }

    @Override
    public ChangeApi rebase(RebaseInput in) throws RestApiException {
        String request = this.getRequestPath() + "/rebase";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        this.gerritRestClient.postRequest(request, json);
        return this.changeApiRestClient;
    }

    @Override
    public void setReviewed(String path, boolean reviewed) throws RestApiException {
        String encodedPath = Url.encode(path);
        String url = String.format("/changes/%s/revisions/%s/files/%s/reviewed", this.changeApiRestClient.id(), this.revision, encodedPath);
        if (reviewed) {
            this.gerritRestClient.putRequest(url);
        } else {
            this.gerritRestClient.deleteRequest(url);
        }
    }

    @Override
    public MergeableInfo mergeable() throws RestApiException {
        String request = this.getRequestPath() + "/mergeable";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.mergeableInfoParser.parseMergeableInfo(jsonElement);
    }

    public SortedMap<String, List<CommentInfo>> comments() throws RestApiException {
        return this.comments("comments");
    }

    public SortedMap<String, List<CommentInfo>> drafts() throws RestApiException {
        return this.comments("drafts");
    }

    @Override
    public Set<String> reviewed() throws RestApiException {
        String request = this.getRequestPath() + "/files?reviewed";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.reviewInfoParser.parseFileInfos(jsonElement);
    }

    private SortedMap<String, List<CommentInfo>> comments(String type) throws RestApiException {
        String request = this.getRequestPath() + '/' + type + '/';
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseCommentInfos(jsonElement);
    }

    @Override
    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
        String request = this.getRequestPath() + "/robotcomments/";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseRobotCommentInfos(jsonElement);
    }

    @Override
    public DraftApi createDraft(DraftInput in) throws RestApiException {
        String request = this.getRequestPath() + "/drafts";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        JsonElement jsonElement = this.gerritRestClient.putRequest(request, json);
        CommentInfo commentInfo = this.commentsParser.parseSingleCommentInfo(jsonElement.getAsJsonObject());
        return new DraftApiRestClient(this.gerritRestClient, this.changeApiRestClient, this, this.commentsParser, commentInfo);
    }

    @Override
    public DraftApi draft(String id) throws RestApiException {
        return new DraftApiRestClient(this.gerritRestClient, this.changeApiRestClient, this, this.commentsParser, id);
    }

    @Override
    public Map<String, FileInfo> files() throws RestApiException {
        return this.files(0);
    }

    @Override
    public Map<String, FileInfo> files(int parentNum) throws RestApiException {
        String request = this.getRequestPath() + "/files";
        if (parentNum > 0) {
            request = request + "?parent=" + parentNum;
        }
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.fileInfoParser.parseFileInfos(jsonElement);
    }

    @Override
    public FileApi file(String path) {
        return new FileApiRestClient(this.gerritRestClient, this, this.commitInfosParser, path);
    }

    @Override
    public CommitInfo commit(boolean addLinks) throws RestApiException {
        String request = this.getRequestPath() + "/commit" + (addLinks ? "?links" : "");
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commitInfosParser.parseSingleCommitInfo(jsonElement.getAsJsonObject());
    }

    @Override
    public BinaryResult patch() throws RestApiException {
        String request = this.getRequestPath() + "/patch";
        try {
            HttpResponse response = this.gerritRestClient.request(request, null, RestClient.HttpVerb.GET, new Header[0]);
            return BinaryResultUtils.createBinaryResult(response);
        }
        catch (IOException e) {
            throw RestApiException.wrap("Failed to get patch.", e);
        }
    }

    @Override
    public Map<String, ActionInfo> actions() throws RestApiException {
        String request = this.getRequestPath() + "/actions";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commitInfosParser.parseActionInfos(jsonElement);
    }

    @Override
    public SubmitType submitType() throws RestApiException {
        String request = this.getRequestPath() + "/submit_type";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return (SubmitType)((Object)this.gerritRestClient.getGson().fromJson(jsonElement, new TypeToken<SubmitType>(){}.getType()));
    }

    @Override
    public BinaryResult submitPreview() throws RestApiException {
        return this.submitPreview(null);
    }

    @Override
    public BinaryResult submitPreview(String format) throws RestApiException {
        String request = this.getRequestPath() + "/preview_submit";
        if (!Strings.isNullOrEmpty((String)format)) {
            request = request + "?format=" + format;
        }
        try {
            HttpResponse response = this.gerritRestClient.request(request, null, RestClient.HttpVerb.GET, new Header[0]);
            return BinaryResultUtils.createBinaryResult(response);
        }
        catch (IOException e) {
            throw RestApiException.wrap("Request failed.", e);
        }
    }

    @Override
    public SubmitType testSubmitType(TestSubmitRuleInput in) throws RestApiException {
        String request = this.getRequestPath() + "/test.submit_type";
        String json = this.gerritRestClient.getGson().toJson((Object)in);
        JsonElement jsonElement = this.gerritRestClient.postRequest(request, json);
        return (SubmitType)((Object)this.gerritRestClient.getGson().fromJson(jsonElement, new TypeToken<SubmitType>(){}.getType()));
    }

    @Override
    public String description() throws RestApiException {
        String request = this.getRequestPath() + "/description";
        return this.gerritRestClient.getRequest(request).getAsString();
    }

    protected String getRequestPath() {
        return this.changeApiRestClient.getRequestPath() + "/revisions/" + this.revision;
    }
}

