/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes.parsers;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeInput;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ChangeInfosParser {
    private static final Type CHANGEINFO_TYPE = new TypeToken<List<ChangeInfo>>(){}.getType();
    private static final Type HASHTAG_TYPE = new TypeToken<Set<String>>(){}.getType();
    private final Gson gson;

    public ChangeInfosParser(Gson gson) {
        this.gson = gson;
    }

    public List<ChangeInfo> parseChangeInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.parseSingleChangeInfo(result));
        }
        return (List)this.gson.fromJson(result, CHANGEINFO_TYPE);
    }

    public ChangeInfo parseSingleChangeInfo(JsonElement result) {
        return (ChangeInfo)this.gson.fromJson(result, ChangeInfo.class);
    }

    public String generateChangeInput(ChangeInput input) {
        return this.gson.toJson((Object)input, ChangeInput.class);
    }

    public Set<String> parseHashtags(JsonElement result) {
        return (Set)this.gson.fromJson(result, HASHTAG_TYPE);
    }

    public IncludedInInfo parseIncludedInInfos(JsonElement jsonElement) {
        return (IncludedInInfo)this.gson.fromJson(jsonElement, IncludedInInfo.class);
    }
}

