/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes.parsers;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.extensions.common.ChangeMessageInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class CommentsParser {
    private static final Type COMMENT_TYPE = new TypeToken<TreeMap<String, List<CommentInfo>>>(){}.getType();
    private static final Type ROBOT_COMMENT_TYPE = new TypeToken<TreeMap<String, List<RobotCommentInfo>>>(){}.getType();
    private static final Type CHANGE_MESSAGE_TYPE = new TypeToken<List<ChangeMessageInfo>>(){}.getType();
    private final Gson gson;

    public CommentsParser(Gson gson) {
        this.gson = gson;
    }

    public SortedMap<String, List<CommentInfo>> parseCommentInfos(JsonElement result) {
        return (SortedMap)this.gson.fromJson(result, COMMENT_TYPE);
    }

    public CommentInfo parseSingleCommentInfo(JsonObject result) {
        return (CommentInfo)this.gson.fromJson((JsonElement)result, CommentInfo.class);
    }

    public SortedMap<String, List<RobotCommentInfo>> parseRobotCommentInfos(JsonElement result) {
        return (SortedMap)this.gson.fromJson(result, ROBOT_COMMENT_TYPE);
    }

    public RobotCommentInfo parseSingleRobotCommentInfo(JsonObject result) {
        return (RobotCommentInfo)this.gson.fromJson((JsonElement)result, RobotCommentInfo.class);
    }

    public List<ChangeMessageInfo> parseChangeMessageInfos(JsonElement result) {
        return (List)this.gson.fromJson(result, CHANGE_MESSAGE_TYPE);
    }

    public ChangeMessageInfo parseSingleChangeMessageInfo(JsonObject result) {
        return (ChangeMessageInfo)this.gson.fromJson((JsonElement)result, ChangeMessageInfo.class);
    }
}

