/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes.parsers;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.DiffInfo;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class CommitInfosParser {
    private static final Type ACTION_TYPE = new TypeToken<TreeMap<String, ActionInfo>>(){}.getType();
    private static final Type COMMIT_INFO_TYPE = new TypeToken<List<CommitInfo>>(){}.getType();
    private static final Type EDIT_INFO_TYPE = new TypeToken<List<EditInfo>>(){}.getType();
    private final Gson gson;

    public CommitInfosParser(Gson gson) {
        this.gson = gson;
    }

    public SortedMap<String, ActionInfo> parseActionInfos(JsonElement result) {
        return (SortedMap)this.gson.fromJson(result, ACTION_TYPE);
    }

    public DiffInfo parseDiffInfo(JsonElement jsonElement) {
        return (DiffInfo)this.gson.fromJson(jsonElement, DiffInfo.class);
    }

    public List<CommitInfo> parseCommitInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList((CommitInfo)this.gson.fromJson(result, CommitInfo.class));
        }
        return (List)this.gson.fromJson(result, COMMIT_INFO_TYPE);
    }

    public CommitInfo parseSingleCommitInfo(JsonObject result) {
        return (CommitInfo)this.gson.fromJson((JsonElement)result, CommitInfo.class);
    }

    public List<EditInfo> parseEditInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList((EditInfo)this.gson.fromJson(result, EditInfo.class));
        }
        return (List)this.gson.fromJson(result, EDIT_INFO_TYPE);
    }
}

