/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.changes.parsers;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.extensions.api.changes.AddReviewerResult;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class ReviewerInfosParser {
    private static final Type REVIEWER_INFO = new TypeToken<List<ReviewerInfo>>(){}.getType();
    private static final Type SUGGESTED_REVIEWER_INFO = new TypeToken<List<SuggestedReviewerInfo>>(){}.getType();
    private final Gson gson;

    public ReviewerInfosParser(Gson gson) {
        this.gson = gson;
    }

    public List<ReviewerInfo> parseReviewerInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList((ReviewerInfo)this.gson.fromJson(result, ReviewerInfo.class));
        }
        return (List)this.gson.fromJson(result, REVIEWER_INFO);
    }

    public List<SuggestedReviewerInfo> parseSuggestReviewerInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList((SuggestedReviewerInfo)this.gson.fromJson(result, SuggestedReviewerInfo.class));
        }
        return (List)this.gson.fromJson(result, SUGGESTED_REVIEWER_INFO);
    }

    public AddReviewerResult parseAddReviewerResult(JsonElement result) {
        return (AddReviewerResult)this.gson.fromJson(result, AddReviewerResult.class);
    }
}

