/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.config;

import com.google.gerrit.extensions.api.config.Server;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.HttpStatusException;
import java.util.concurrent.atomic.AtomicReference;

public class ServerRestClient
extends Server.NotImplemented
implements Server {
    private final GerritRestClient gerritRestClient;
    private final AtomicReference<String> version = new AtomicReference();

    public ServerRestClient(GerritRestClient gerritRestClient) {
        this.gerritRestClient = gerritRestClient;
    }

    @Override
    public String getVersion() throws RestApiException {
        try {
            JsonElement jsonElement = this.gerritRestClient.getRequest("/config/server/version");
            this.version.set(jsonElement.getAsString());
            return this.version.get();
        }
        catch (HttpStatusException e) {
            int statusCode = e.getStatusCode();
            if (statusCode == 404) {
                return "<2.8";
            }
            throw e;
        }
    }

    public String getVersionCached() throws RestApiException {
        String gerritVersion = this.version.get();
        return gerritVersion == null ? this.getVersion() : gerritVersion;
    }
}

