/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.projects;

import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.api.projects.CommitApi;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.projects.ProjectApiRestClient;
import com.urswolfer.gerrit.client.rest.http.projects.parsers.ProjectCommitInfoParser;

public class CommitApiRestClient
extends CommitApi.NotImplemented
implements CommitApi {
    private final GerritRestClient gerritRestClient;
    private final ProjectApiRestClient projectApiRestClient;
    private final ProjectCommitInfoParser projectCommitInfoParser;
    private final String commit;

    public CommitApiRestClient(GerritRestClient gerritRestClient, ProjectApiRestClient projectApiRestClient, ProjectCommitInfoParser projectCommitInfoParser, String commit) {
        this.gerritRestClient = gerritRestClient;
        this.projectApiRestClient = projectApiRestClient;
        this.commit = commit;
        this.projectCommitInfoParser = projectCommitInfoParser;
    }

    @Override
    public CommitInfo get() throws RestApiException {
        JsonElement jsonElement = this.gerritRestClient.getRequest(this.commitURL());
        return this.projectCommitInfoParser.parseSingleCommitInfo(jsonElement);
    }

    @Override
    public IncludedInInfo includedIn() throws RestApiException {
        JsonElement jsonElement = this.gerritRestClient.getRequest(this.commitURL() + "/in");
        return this.projectCommitInfoParser.parseIncludedInInfo(jsonElement);
    }

    protected String commitURL() {
        return this.projectApiRestClient.projectsUrl() + "/commits/" + Url.encode(this.commit);
    }
}

