/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.projects;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import com.google.gerrit.extensions.api.access.ProjectAccessInput;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.SortedMap;

public class ProjectsParser {
    private static final Type TYPE = new TypeToken<SortedMap<String, ProjectInfo>>(){}.getType();
    private final Gson gson;

    public ProjectsParser(Gson gson) {
        this.gson = gson;
    }

    public SortedMap<String, ProjectInfo> parseProjectInfos(JsonElement result) {
        return (SortedMap)this.gson.fromJson(result, TYPE);
    }

    public ProjectInfo parseSingleProjectInfo(JsonElement result) {
        return (ProjectInfo)this.gson.fromJson(result, ProjectInfo.class);
    }

    public String generateProjectInput(ProjectInput input) {
        return this.gson.toJson((Object)input, ProjectInput.class);
    }

    public ProjectAccessInfo parseProjectAccessInfo(JsonElement result) {
        return (ProjectAccessInfo)this.gson.fromJson(result, ProjectAccessInfo.class);
    }

    public String generateProjectAccessInput(ProjectAccessInput input) {
        return this.gson.toJson((Object)input);
    }
}

