/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.projects;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.projects.ProjectApi;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.api.projects.Projects;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.projects.BranchInfoParser;
import com.urswolfer.gerrit.client.rest.http.projects.ProjectApiRestClient;
import com.urswolfer.gerrit.client.rest.http.projects.ProjectsParser;
import com.urswolfer.gerrit.client.rest.http.projects.TagInfoParser;
import com.urswolfer.gerrit.client.rest.http.projects.parsers.ProjectCommitInfoParser;
import com.urswolfer.gerrit.client.rest.http.util.UrlUtils;
import java.util.SortedMap;
import java.util.TreeMap;

public class ProjectsRestClient
extends Projects.NotImplemented
implements Projects {
    private final GerritRestClient gerritRestClient;
    private final ProjectsParser projectsParser;
    private final BranchInfoParser branchInfoParser;
    private final TagInfoParser tagInfoParser;
    private final ProjectCommitInfoParser projectCommitInfoParser;

    public ProjectsRestClient(GerritRestClient gerritRestClient, ProjectsParser projectsParser, BranchInfoParser branchInfoParser, TagInfoParser tagInfoParser, ProjectCommitInfoParser projectCommitInfoParser) {
        this.gerritRestClient = gerritRestClient;
        this.projectsParser = projectsParser;
        this.branchInfoParser = branchInfoParser;
        this.tagInfoParser = tagInfoParser;
        this.projectCommitInfoParser = projectCommitInfoParser;
    }

    @Override
    public Projects.ListRequest list() {
        return new Projects.ListRequest(){

            @Override
            public SortedMap<String, ProjectInfo> getAsMap() throws RestApiException {
                return ProjectsRestClient.this.list(this);
            }
        };
    }

    @Override
    public ProjectApi name(String name) throws RestApiException {
        return new ProjectApiRestClient(this.gerritRestClient, this.projectsParser, this.branchInfoParser, this.tagInfoParser, this.projectCommitInfoParser, name);
    }

    private SortedMap<String, ProjectInfo> list(Projects.ListRequest listParameter) throws RestApiException {
        JsonElement result;
        String query = "";
        if (listParameter.getDescription()) {
            query = UrlUtils.appendToUrlQuery(query, "d");
        }
        if (listParameter.getShowTree()) {
            query = UrlUtils.appendToUrlQuery(query, "t");
        }
        if (!Strings.isNullOrEmpty((String)listParameter.getPrefix())) {
            query = UrlUtils.appendToUrlQuery(query, "p=" + listParameter.getPrefix());
        }
        if (listParameter.getLimit() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "n=" + listParameter.getLimit());
        }
        if (listParameter.getStart() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "S=" + listParameter.getStart());
        }
        for (String branch : listParameter.getBranches()) {
            query = UrlUtils.appendToUrlQuery(query, "b=" + branch);
        }
        Projects.ListRequest.FilterType filterType = listParameter.getFilterType();
        if (filterType != null && filterType != Projects.ListRequest.FilterType.ALL) {
            query = UrlUtils.appendToUrlQuery(query, "type=" + (Object)((Object)filterType));
        }
        String url = "/projects/";
        if (!Strings.isNullOrEmpty((String)query)) {
            url = url + '?' + query;
        }
        if ((result = this.gerritRestClient.getRequest(url)) == null) {
            return new TreeMap<String, ProjectInfo>();
        }
        return this.projectsParser.parseProjectInfos(result);
    }

    @Override
    public ProjectApi create(String name) throws RestApiException {
        ProjectInput projectInput = new ProjectInput();
        projectInput.name = name;
        return this.create(projectInput);
    }

    @Override
    public ProjectApi create(ProjectInput in) throws RestApiException {
        if (in.name == null) {
            throw new IllegalArgumentException("Name must be set in project creation input.");
        }
        String url = String.format("/projects/%s", Url.encode(in.name));
        String projectInput = this.projectsParser.generateProjectInput(in);
        JsonElement result = this.gerritRestClient.putRequest(url, projectInput);
        ProjectInfo info = this.projectsParser.parseSingleProjectInfo(result);
        return new ProjectApiRestClient(this.gerritRestClient, this.projectsParser, this.branchInfoParser, this.tagInfoParser, this.projectCommitInfoParser, info.name);
    }
}

