/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.projects;

import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.api.projects.TagApi;
import com.google.gerrit.extensions.api.projects.TagInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gson.JsonElement;
import com.urswolfer.gerrit.client.rest.http.GerritRestClient;
import com.urswolfer.gerrit.client.rest.http.projects.ProjectApiRestClient;
import com.urswolfer.gerrit.client.rest.http.projects.TagInfoParser;

public class TagApiRestClient
extends TagApi.NotImplemented
implements TagApi {
    private final GerritRestClient gerritRestClient;
    private final TagInfoParser tagInfoParser;
    private final ProjectApiRestClient projectApiRestClient;
    private final String name;

    public TagApiRestClient(GerritRestClient gerritRestClient, TagInfoParser tagInfoParser, ProjectApiRestClient projectApiRestClient, String name) {
        this.gerritRestClient = gerritRestClient;
        this.tagInfoParser = tagInfoParser;
        this.projectApiRestClient = projectApiRestClient;
        this.name = name;
    }

    @Override
    public TagInfo get() throws RestApiException {
        JsonElement jsonElement = this.gerritRestClient.getRequest(this.tagUrl());
        return (TagInfo)Iterables.getOnlyElement(this.tagInfoParser.parseTagInfos(jsonElement));
    }

    protected String tagUrl() {
        return this.projectApiRestClient.projectsUrl() + "/tags/" + this.name;
    }
}

