/*
 * Decompiled with CFR 0.152.
 */
package com.urswolfer.gerrit.client.rest.http.util;

import com.google.gerrit.extensions.restapi.BinaryResult;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class BinaryResultUtils {
    private BinaryResultUtils() {
    }

    public static BinaryResult createBinaryResult(HttpResponse response) throws IOException {
        InputStream content = response.getEntity().getContent();
        BinaryResult binaryResult = BinaryResult.create(content);
        BinaryResultUtils.setContentType(response, binaryResult);
        BinaryResultUtils.setContentEncoding(response, binaryResult);
        return binaryResult;
    }

    private static void setContentType(HttpResponse response, BinaryResult binaryResult) {
        Header fileContentType = response.getFirstHeader("X-FYI-Content-Type");
        if (fileContentType == null) {
            fileContentType = response.getFirstHeader("Content-Type");
        }
        if (fileContentType != null) {
            binaryResult.setContentType(fileContentType.getValue());
        }
    }

    private static void setContentEncoding(HttpResponse response, BinaryResult binaryResult) {
        Header contentEncoding = response.getFirstHeader("X-FYI-Content-Encoding");
        if (contentEncoding != null && "base64".equals(contentEncoding.getValue())) {
            binaryResult.base64();
        }
    }
}

