/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import androidx.annotation.Nullable;
import com.usebutton.merchant.ButtonApi;
import com.usebutton.merchant.ButtonProductCompatible;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.Task;
import com.usebutton.merchant.module.Features;
import java.util.List;

public class ActivityReportingTask
extends Task<Void> {
    private final ButtonApi buttonApi;
    private final DeviceManager deviceManager;
    private final Features features;
    private final String activityName;
    private final List<ButtonProductCompatible> products;
    private final String sourceToken;

    public ActivityReportingTask(ButtonApi buttonApi, DeviceManager deviceManager, Features features, String activityName, List<ButtonProductCompatible> products, @Nullable String sourceToken, @Nullable Task.Listener<Void> listener) {
        super(listener);
        this.buttonApi = buttonApi;
        this.deviceManager = deviceManager;
        this.features = features;
        this.activityName = activityName;
        this.products = products;
        this.sourceToken = sourceToken;
    }

    @Override
    @Nullable
    Void execute() throws Exception {
        String advertisingId = this.features.getIncludesIfa() ? this.deviceManager.getAdvertisingId() : null;
        return this.buttonApi.postActivity(this.activityName, this.products, this.sourceToken, advertisingId);
    }
}

