/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class ApiRequest {
    private final RequestMethod requestMethod;
    private final String path;
    private final Map<String, String> headers;
    private final JSONObject body;

    private ApiRequest(Builder builder) {
        this.requestMethod = builder.requestMethod;
        this.path = builder.path;
        this.headers = builder.headers;
        this.body = builder.body;
    }

    RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    String getPath() {
        return this.path;
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }

    JSONObject getBody() {
        return this.body;
    }

    static class Builder {
        private final RequestMethod requestMethod;
        private final String path;
        private Map<String, String> headers = new HashMap<String, String>();
        private JSONObject body = new JSONObject();

        Builder(RequestMethod requestMethod, String path) {
            this.requestMethod = requestMethod;
            this.path = path;
        }

        Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        Builder setBody(JSONObject body) {
            this.body = body;
            return this;
        }

        ApiRequest build() {
            return new ApiRequest(this);
        }
    }

    static enum RequestMethod {
        POST("POST");

        private final String value;

        private RequestMethod(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }
}

