/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.usebutton.merchant.ApiRequest;
import com.usebutton.merchant.ButtonApi;
import com.usebutton.merchant.ButtonProductCompatible;
import com.usebutton.merchant.ButtonUtil;
import com.usebutton.merchant.ConnectionManager;
import com.usebutton.merchant.Event;
import com.usebutton.merchant.NetworkResponse;
import com.usebutton.merchant.Order;
import com.usebutton.merchant.PostInstallLink;
import com.usebutton.merchant.exception.ButtonNetworkException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ButtonApiImpl
implements ButtonApi {
    private static final String TAG = ButtonApiImpl.class.getSimpleName();
    private static ButtonApi buttonApi;
    private final ConnectionManager connectionManager;

    static ButtonApi getInstance(ConnectionManager connectionManager) {
        if (buttonApi == null) {
            buttonApi = new ButtonApiImpl(connectionManager);
        }
        return buttonApi;
    }

    @VisibleForTesting
    ButtonApiImpl(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void setApplicationId(String applicationId) {
        this.connectionManager.setApplicationId(applicationId);
    }

    @Override
    @Nullable
    public String getApplicationId() {
        return this.connectionManager.getApplicationId();
    }

    @Override
    @Nullable
    @WorkerThread
    public PostInstallLink getPendingLink(String applicationId, @Nullable String advertisingId, Map<String, String> signalsMap) throws ButtonNetworkException {
        try {
            JSONObject requestBody = new JSONObject();
            requestBody.put("application_id", (Object)applicationId);
            requestBody.put("ifa", (Object)advertisingId);
            requestBody.put("signals", (Object)new JSONObject(signalsMap));
            ApiRequest apiRequest = new ApiRequest.Builder(ApiRequest.RequestMethod.POST, "/v1/app/deferred-deeplink").setBody(requestBody).build();
            NetworkResponse response = this.connectionManager.executeRequest(apiRequest);
            JSONObject responseBody = response.getBody().optJSONObject("object");
            if (responseBody != null) {
                boolean match = responseBody.getBoolean("match");
                String id = responseBody.getString("id");
                String action = responseBody.getString("action");
                PostInstallLink.Attribution attribution = null;
                JSONObject attributionJson = responseBody.optJSONObject("attribution");
                if (attributionJson != null) {
                    String btnRef = attributionJson.getString("btn_ref");
                    String utmSource = attributionJson.optString("utm_source", null);
                    attribution = new PostInstallLink.Attribution(btnRef, utmSource);
                }
                return new PostInstallLink(match, id, action, attribution);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error creating request body", (Throwable)e);
            throw new ButtonNetworkException((Exception)((Object)e));
        }
        return null;
    }

    @Override
    @Nullable
    public Void postOrder(Order order, String applicationId, String sourceToken, @Nullable String advertisingId) throws ButtonNetworkException {
        try {
            Order.Customer customer;
            JSONObject requestBody = new JSONObject();
            requestBody.put("currency", (Object)order.getCurrencyCode());
            requestBody.put("btn_ref", (Object)sourceToken);
            requestBody.put("order_id", (Object)order.getId());
            requestBody.put("purchase_date", (Object)ButtonUtil.formatDate(order.getPurchaseDate()));
            requestBody.put("customer_order_id", (Object)order.getCustomerOrderId());
            requestBody.put("advertising_id", (Object)advertisingId);
            JSONArray lineItemsJson = new JSONArray();
            for (int i = 0; i < order.getLineItems().size(); ++i) {
                Order.LineItem lineItem = order.getLineItems().get(i);
                JSONObject lineItemJson = new JSONObject();
                List<String> lineItemCategory = lineItem.getCategory();
                if (lineItemCategory != null) {
                    JSONArray categoryJson = new JSONArray();
                    for (String category : lineItemCategory) {
                        categoryJson.put((Object)category);
                    }
                    lineItemJson.put("category", (Object)categoryJson);
                }
                lineItemJson.put("identifier", (Object)lineItem.getId());
                lineItemJson.put("quantity", lineItem.getQuantity());
                lineItemJson.put("total", lineItem.getTotal());
                Map<String, String> lineItemAttributes = lineItem.getAttributes();
                if (lineItemAttributes != null) {
                    JSONObject attributesJson = new JSONObject();
                    for (Map.Entry<String, String> entry : lineItemAttributes.entrySet()) {
                        attributesJson.put(entry.getKey(), (Object)entry.getValue());
                    }
                    lineItemJson.put("attributes", (Object)attributesJson);
                }
                lineItemJson.put("upc", (Object)lineItem.getUpc());
                lineItemJson.put("description", (Object)lineItem.getDescription());
                lineItemJson.put("sku", (Object)lineItem.getSku());
                lineItemsJson.put(i, (Object)lineItemJson);
            }
            if (lineItemsJson.length() > 0) {
                requestBody.put("line_items", (Object)lineItemsJson);
            }
            if ((customer = order.getCustomer()) != null) {
                JSONObject customerJson = new JSONObject();
                customerJson.put("id", (Object)customer.getId());
                String email = customer.getEmail();
                if (email != null) {
                    if (ButtonUtil.isValidEmail(email)) {
                        email = ButtonUtil.sha256Encode(email.toLowerCase());
                    }
                    customerJson.put("email_sha256", (Object)email);
                }
                if (customer.isNew() != null) {
                    customerJson.put("is_new", (Object)customer.isNew());
                }
                requestBody.put("customer", (Object)customerJson);
            }
            applicationId = ButtonUtil.base64Encode(applicationId + ":");
            ApiRequest apiRequest = new ApiRequest.Builder(ApiRequest.RequestMethod.POST, "/v1/app/order").addHeader("Authorization", String.format("Basic %s", applicationId)).setBody(requestBody).build();
            this.connectionManager.executeRequest(apiRequest);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error creating request body", (Throwable)e);
            throw new ButtonNetworkException((Exception)((Object)e));
        }
        return null;
    }

    @Override
    @Nullable
    public Void postActivity(String activityName, List<ButtonProductCompatible> products, @Nullable String sourceToken, @Nullable String advertisingId) throws ButtonNetworkException {
        try {
            JSONObject requestBody = new JSONObject();
            JSONObject activityBody = new JSONObject();
            requestBody.put("ifa", (Object)advertisingId);
            requestBody.put("btn_ref", (Object)sourceToken);
            activityBody.put("name", (Object)activityName);
            if (!products.isEmpty()) {
                JSONArray productsArray = new JSONArray();
                for (int i = 0; i < products.size(); ++i) {
                    ButtonProductCompatible product = products.get(i);
                    List<String> categories = product.getCategories();
                    Map<String, String> attributes = product.getAttributes();
                    JSONObject productJson = new JSONObject();
                    JSONArray categoriesJson = new JSONArray();
                    if (categories != null) {
                        for (int j = 0; j < categories.size(); ++j) {
                            categoriesJson.put(j, (Object)categories.get(j));
                        }
                        productJson.put("categories", (Object)categoriesJson);
                    }
                    JSONObject attributesJson = new JSONObject();
                    if (attributes != null) {
                        for (Map.Entry<String, String> entry : attributes.entrySet()) {
                            attributesJson.putOpt(entry.getKey(), (Object)entry.getValue());
                        }
                        productJson.put("attributes", (Object)attributesJson);
                    }
                    productJson.put("id", (Object)product.getId());
                    productJson.put("upc", (Object)product.getUpc());
                    productJson.put("name", (Object)product.getName());
                    productJson.put("currency", (Object)product.getCurrency());
                    productJson.put("value", (Object)product.getValue());
                    productJson.put("quantity", (Object)product.getQuantity());
                    productJson.put("url", (Object)product.getUrl());
                    productsArray.put(i, (Object)productJson);
                }
                activityBody.put("products", (Object)productsArray);
            }
            requestBody.put("activity_data", (Object)activityBody);
            ApiRequest apiRequest = new ApiRequest.Builder(ApiRequest.RequestMethod.POST, "/v1/app/activity").setBody(requestBody).build();
            this.connectionManager.executeRequest(apiRequest);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error creating request body", (Throwable)e);
            throw new ButtonNetworkException((Exception)((Object)e));
        }
        return null;
    }

    @Override
    @Nullable
    public Void postEvents(List<Event> events, @Nullable String advertisingId) throws ButtonNetworkException {
        try {
            JSONArray eventStream = new JSONArray();
            for (int i = 0; i < events.size(); ++i) {
                JSONObject eventJson = events.get(i).toJson();
                eventStream.put(i, (Object)eventJson);
            }
            JSONObject requestBody = new JSONObject();
            requestBody.put("ifa", (Object)advertisingId);
            requestBody.put("current_time", (Object)ButtonUtil.formatDate(new Date()));
            requestBody.put("events", (Object)eventStream);
            ApiRequest apiRequest = new ApiRequest.Builder(ApiRequest.RequestMethod.POST, "/v1/app/events").setBody(requestBody).build();
            this.connectionManager.executeRequest(apiRequest);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error creating request body", (Throwable)e);
            throw new ButtonNetworkException((Exception)((Object)e));
        }
        return null;
    }
}

