/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.ButtonInternal;
import com.usebutton.merchant.ButtonMerchant;
import com.usebutton.merchant.ButtonRepository;
import com.usebutton.merchant.ButtonUtil;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.Event;
import com.usebutton.merchant.Order;
import com.usebutton.merchant.OrderListener;
import com.usebutton.merchant.PostInstallIntentListener;
import com.usebutton.merchant.PostInstallLink;
import com.usebutton.merchant.Task;
import com.usebutton.merchant.TestManager;
import com.usebutton.merchant.exception.ApplicationIdNotFoundException;
import com.usebutton.merchant.module.Features;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

final class ButtonInternalImpl
implements ButtonInternal {
    private static final String TAG = ButtonMerchant.class.getSimpleName();
    @VisibleForTesting
    ArrayList<ButtonMerchant.AttributionTokenListener> attributionTokenListeners;
    private final Executor executor;
    private final AtomicBoolean hasReceivedDirectDeeplink = new AtomicBoolean();

    ButtonInternalImpl(Executor executor) {
        this.attributionTokenListeners = new ArrayList();
        this.executor = executor;
    }

    @Override
    public void configure(ButtonRepository buttonRepository, String applicationId) {
        if (!ButtonUtil.isApplicationIdValid(applicationId)) {
            Log.e((String)TAG, (String)("Application ID [" + applicationId + "] is not valid. You can find your Application ID in the dashboard by logging in at https://app.usebutton.com/"));
        }
        buttonRepository.setApplicationId(applicationId);
    }

    @Override
    @Nullable
    public String getApplicationId(ButtonRepository buttonRepository) {
        return buttonRepository.getApplicationId();
    }

    @Override
    public void trackIncomingIntent(TestManager testManager, ButtonRepository buttonRepository, DeviceManager deviceManager, Features features, Intent intent) {
        Uri data = intent.getData();
        if (data == null) {
            return;
        }
        String sourceToken = data.getQueryParameter("btn_ref");
        if (sourceToken != null && !sourceToken.isEmpty()) {
            this.setAttributionToken(buttonRepository, sourceToken);
            this.hasReceivedDirectDeeplink.set(true);
        }
        testManager.parseIntent(intent);
        this.reportDeeplinkOpenEvent(buttonRepository, deviceManager, features, data);
    }

    @Override
    @Nullable
    public String getAttributionToken(ButtonRepository buttonRepository) {
        return buttonRepository.getSourceToken();
    }

    @Override
    public void addAttributionTokenListener(ButtonRepository buttonRepository, @NonNull ButtonMerchant.AttributionTokenListener listener) {
        this.attributionTokenListeners.add(listener);
    }

    @Override
    public void removeAttributionTokenListener(ButtonRepository buttonRepository, @NonNull ButtonMerchant.AttributionTokenListener listener) {
        this.attributionTokenListeners.remove(listener);
    }

    @Override
    public void clearAllData(ButtonRepository buttonRepository) {
        buttonRepository.clear();
    }

    @Override
    public void handlePostInstallIntent(final ButtonRepository buttonRepository, DeviceManager deviceManager, Features features, final String packageName, final PostInstallIntentListener listener) {
        if (buttonRepository.getApplicationId() == null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.onResult(null, new ApplicationIdNotFoundException());
                }
            });
            return;
        }
        if (deviceManager.isOldInstallation() || buttonRepository.checkedDeferredDeepLink()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.onResult(null, null);
                }
            });
            return;
        }
        buttonRepository.updateCheckDeferredDeepLink(true);
        buttonRepository.getPendingLink(deviceManager, features, new Task.Listener<PostInstallLink>(){

            @Override
            public void onTaskComplete(@Nullable PostInstallLink postInstallLink) {
                if (ButtonInternalImpl.this.hasReceivedDirectDeeplink.get()) {
                    ButtonInternalImpl.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onResult(null, null);
                        }
                    });
                    return;
                }
                if (postInstallLink != null && postInstallLink.isMatch() && postInstallLink.getAction() != null) {
                    final Intent deepLinkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)postInstallLink.getAction()));
                    deepLinkIntent.setPackage(packageName);
                    PostInstallLink.Attribution attribution = postInstallLink.getAttribution();
                    if (attribution != null) {
                        ButtonInternalImpl.this.setAttributionToken(buttonRepository, attribution.getBtnRef());
                    }
                    ButtonInternalImpl.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onResult(deepLinkIntent, null);
                        }
                    });
                    return;
                }
                ButtonInternalImpl.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResult(null, null);
                    }
                });
            }

            @Override
            public void onTaskError(final Throwable throwable) {
                ButtonInternalImpl.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResult(null, throwable);
                    }
                });
            }
        });
    }

    @Override
    public void reportOrder(ButtonRepository buttonRepository, DeviceManager deviceManager, Features features, Order order, final @Nullable OrderListener orderListener) {
        if (buttonRepository.getApplicationId() == null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (orderListener != null) {
                        orderListener.onResult(new ApplicationIdNotFoundException());
                    }
                }
            });
            return;
        }
        buttonRepository.postOrder(order, deviceManager, features, new Task.Listener(){

            public void onTaskComplete(@Nullable Object object) {
                if (orderListener != null) {
                    orderListener.onResult(null);
                }
            }

            @Override
            public void onTaskError(Throwable throwable) {
                if (orderListener != null) {
                    orderListener.onResult(throwable);
                }
            }
        });
    }

    @Override
    public void reportCustomEvent(ButtonRepository buttonRepository, DeviceManager deviceManager, Features features, String eventName, Map<String, String> properties) {
        if (buttonRepository.getApplicationId() == null) {
            Log.e((String)TAG, (String)"Application ID [null] is not valid. You can find your Application ID in the dashboard by logging in at https://app.usebutton.com/");
            return;
        }
        String sourceToken = this.getAttributionToken(buttonRepository);
        Event event = new Event(eventName, sourceToken, properties);
        buttonRepository.reportEvent(deviceManager, features, event);
    }

    private void setAttributionToken(ButtonRepository buttonRepository, final String attributionToken) {
        if (attributionToken != null && !attributionToken.isEmpty()) {
            if (!attributionToken.equals(this.getAttributionToken(buttonRepository))) {
                for (final ButtonMerchant.AttributionTokenListener listener : this.attributionTokenListeners) {
                    if (listener == null) continue;
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onAttributionTokenChanged(attributionToken);
                        }
                    });
                }
            }
            buttonRepository.setSourceToken(attributionToken);
        }
    }

    private void reportDeeplinkOpenEvent(ButtonRepository buttonRepository, DeviceManager deviceManager, Features features, @Nullable Uri link) {
        if (link == null) {
            return;
        }
        Uri.Builder strippedLinkBuilder = link.buildUpon().clearQuery();
        Set params = link.getQueryParameterNames();
        for (String param : params) {
            if (!param.startsWith("btn_") && !"from_landing".equalsIgnoreCase(param) && !"from_tracking".equalsIgnoreCase(param)) continue;
            strippedLinkBuilder.appendQueryParameter(param, link.getQueryParameter(param));
        }
        String strippedLink = strippedLinkBuilder.build().toString();
        String sourceToken = this.getAttributionToken(buttonRepository);
        Event deeplinkEvent = new Event(Event.Name.DEEPLINK_OPENED, sourceToken);
        deeplinkEvent.addProperty(Event.Property.URL, strippedLink);
        buttonRepository.reportEvent(deviceManager, features, deeplinkEvent);
    }
}

