/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.ButtonApi;
import com.usebutton.merchant.ButtonApiImpl;
import com.usebutton.merchant.ButtonInternal;
import com.usebutton.merchant.ButtonInternalImpl;
import com.usebutton.merchant.ButtonRepository;
import com.usebutton.merchant.ButtonRepositoryImpl;
import com.usebutton.merchant.ButtonUserActivityImpl;
import com.usebutton.merchant.ConnectionManager;
import com.usebutton.merchant.ConnectionManagerImpl;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.DeviceManagerImpl;
import com.usebutton.merchant.FeaturesImpl;
import com.usebutton.merchant.MainThreadExecutor;
import com.usebutton.merchant.Order;
import com.usebutton.merchant.OrderListener;
import com.usebutton.merchant.PersistenceManager;
import com.usebutton.merchant.PersistenceManagerImpl;
import com.usebutton.merchant.PostInstallIntentListener;
import com.usebutton.merchant.TestManager;
import com.usebutton.merchant.UserActivityListener;
import com.usebutton.merchant.module.ButtonUserActivity;
import com.usebutton.merchant.module.Features;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ButtonMerchant {
    private static Executor executor = new MainThreadExecutor();
    @VisibleForTesting
    static ButtonInternal buttonInternal = new ButtonInternalImpl(executor);
    @VisibleForTesting
    static ButtonUserActivity activity = ButtonUserActivityImpl.getInstance();
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();
    static final String BASE_URL = "https://mobileapi.usebutton.com";
    static final String FMT_BASE_URL_APP_ID = "https://%s.mobileapi.usebutton.com";

    private ButtonMerchant() {
    }

    public static void configure(@NonNull Context context, @NonNull String applicationId) {
        buttonInternal.configure(ButtonMerchant.getButtonRepository(context), applicationId);
        ((ButtonUserActivityImpl)ButtonMerchant.activity()).flushQueue(ButtonMerchant.getButtonRepository(context));
    }

    public static void trackIncomingIntent(@NonNull Context context, @NonNull Intent intent) {
        TestManager testManager = new TestManager(context, ButtonMerchant.getButtonRepository(context), new TestManager.Terminator());
        buttonInternal.trackIncomingIntent(testManager, ButtonMerchant.getButtonRepository(context), ButtonMerchant.getDeviceManager(context), ButtonMerchant.features(), intent);
    }

    @Deprecated
    public static void trackOrder(@NonNull Context context, @NonNull Order order, @Nullable UserActivityListener userActivityListener) {
        if (userActivityListener != null) {
            Throwable error = new Throwable("trackOrder(~) is no longer supported. You can safely remove your usage of this method.");
            userActivityListener.onResult(error);
        }
    }

    public static void reportOrder(@NonNull Context context, @NonNull Order order, @Nullable OrderListener orderListener) {
        buttonInternal.reportOrder(ButtonMerchant.getButtonRepository(context), ButtonMerchant.getDeviceManager(context), FeaturesImpl.getInstance(), order, orderListener);
    }

    public static void reportEvent(@NonNull Context context, @NonNull String name, @Nullable Map<String, String> properties) {
        buttonInternal.reportCustomEvent(ButtonMerchant.getButtonRepository(context), ButtonMerchant.getDeviceManager(context), FeaturesImpl.getInstance(), name, properties);
    }

    public static void reportEvent(@NonNull Context context, @NonNull String name) {
        ButtonMerchant.reportEvent(context, name, null);
    }

    @Nullable
    public static String getAttributionToken(@NonNull Context context) {
        return buttonInternal.getAttributionToken(ButtonMerchant.getButtonRepository(context));
    }

    public static void addAttributionTokenListener(@NonNull Context context, @NonNull AttributionTokenListener listener) {
        buttonInternal.addAttributionTokenListener(ButtonMerchant.getButtonRepository(context), listener);
    }

    public static void removeAttributionTokenListener(@NonNull Context context, @NonNull AttributionTokenListener listener) {
        buttonInternal.removeAttributionTokenListener(ButtonMerchant.getButtonRepository(context), listener);
    }

    public static void clearAllData(@NonNull Context context) {
        buttonInternal.clearAllData(ButtonMerchant.getButtonRepository(context));
    }

    public static void handlePostInstallIntent(@NonNull Context context, @NonNull PostInstallIntentListener listener) {
        buttonInternal.handlePostInstallIntent(ButtonMerchant.getButtonRepository(context), ButtonMerchant.getDeviceManager(context), FeaturesImpl.getInstance(), context.getPackageName(), listener);
    }

    public static Features features() {
        return FeaturesImpl.getInstance();
    }

    public static ButtonUserActivity activity() {
        return activity;
    }

    private static ButtonRepository getButtonRepository(Context context) {
        PersistenceManager persistenceManager = PersistenceManagerImpl.getInstance(context.getApplicationContext());
        DeviceManager deviceManager = ButtonMerchant.getDeviceManager(context);
        ConnectionManager connectionManager = ConnectionManagerImpl.getInstance(BASE_URL, deviceManager.getUserAgent(), persistenceManager);
        ButtonApi buttonApi = ButtonApiImpl.getInstance(connectionManager);
        return ButtonRepositoryImpl.getInstance(buttonApi, deviceManager, ButtonMerchant.features(), persistenceManager, executorService);
    }

    private static DeviceManager getDeviceManager(Context context) {
        return DeviceManagerImpl.getInstance(context.getApplicationContext());
    }

    public static interface AttributionTokenListener {
        public void onAttributionTokenChanged(@NonNull String var1);
    }
}

