/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.ActivityReportingTask;
import com.usebutton.merchant.ButtonApi;
import com.usebutton.merchant.ButtonProductCompatible;
import com.usebutton.merchant.ButtonRepository;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.Event;
import com.usebutton.merchant.EventReportingTask;
import com.usebutton.merchant.GetPendingLinkTask;
import com.usebutton.merchant.Order;
import com.usebutton.merchant.PersistenceManager;
import com.usebutton.merchant.PostInstallLink;
import com.usebutton.merchant.PostOrderTask;
import com.usebutton.merchant.Task;
import com.usebutton.merchant.ThreadManager;
import com.usebutton.merchant.module.Features;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

final class ButtonRepositoryImpl
implements ButtonRepository {
    private static final String TAG = ButtonRepository.class.getSimpleName();
    private final ButtonApi buttonApi;
    private final DeviceManager deviceManager;
    private final Features features;
    private final PersistenceManager persistenceManager;
    private final ExecutorService executorService;
    private static ButtonRepository buttonRepository;
    private boolean isConfigured;
    private List<Task<?>> pendingTasks = new CopyOnWriteArrayList();

    static ButtonRepository getInstance(ButtonApi buttonApi, DeviceManager deviceManager, Features features, PersistenceManager persistenceManager, ExecutorService executorService) {
        if (buttonRepository == null) {
            buttonRepository = new ButtonRepositoryImpl(buttonApi, deviceManager, features, persistenceManager, executorService);
        }
        return buttonRepository;
    }

    @VisibleForTesting
    ButtonRepositoryImpl(ButtonApi buttonApi, DeviceManager deviceManager, Features features, PersistenceManager persistenceManager, ExecutorService executorService) {
        this.buttonApi = buttonApi;
        this.deviceManager = deviceManager;
        this.features = features;
        this.persistenceManager = persistenceManager;
        this.executorService = executorService;
    }

    @Override
    public void setApplicationId(String applicationId) {
        this.isConfigured = true;
        this.buttonApi.setApplicationId(applicationId);
        for (Task<?> task : this.pendingTasks) {
            this.executorService.submit(task);
        }
        this.pendingTasks.clear();
    }

    @Override
    @Nullable
    public String getApplicationId() {
        return this.buttonApi.getApplicationId();
    }

    @Override
    public void setSourceToken(String sourceToken) {
        this.persistenceManager.setSourceToken(sourceToken);
    }

    @Override
    @Nullable
    public String getSourceToken() {
        return this.persistenceManager.getSourceToken();
    }

    @Override
    public void clear() {
        this.persistenceManager.clear();
    }

    @Override
    public void getPendingLink(DeviceManager deviceManager, Features features, Task.Listener<PostInstallLink> listener) {
        GetPendingLinkTask getPendingLinkTask = new GetPendingLinkTask(this.buttonApi, deviceManager, features, this.getApplicationId(), listener);
        this.executorService.submit(getPendingLinkTask);
    }

    @Override
    public boolean checkedDeferredDeepLink() {
        return this.persistenceManager.checkedDeferredDeepLink();
    }

    @Override
    public void updateCheckDeferredDeepLink(boolean checkedDeferredDeepLink) {
        this.persistenceManager.updateCheckDeferredDeepLink(checkedDeferredDeepLink);
    }

    @Override
    public void postOrder(Order order, DeviceManager deviceManager, Features features, Task.Listener listener) {
        this.executorService.submit(new PostOrderTask(listener, this.buttonApi, order, this.getApplicationId(), this.getSourceToken(), deviceManager, features, new ThreadManager()));
    }

    @Override
    public void trackActivity(final String eventName, List<ButtonProductCompatible> products) {
        ActivityReportingTask task = new ActivityReportingTask(this.buttonApi, this.deviceManager, this.features, eventName, products, this.getSourceToken(), new Task.Listener<Void>(){

            @Override
            public void onTaskComplete(@Nullable Void object) {
            }

            @Override
            public void onTaskError(Throwable throwable) {
                Log.e((String)TAG, (String)String.format("Error reporting user activity [%s]", eventName), (Throwable)throwable);
            }
        });
        this.invokeIfConfigured(task);
    }

    @Override
    public void reportEvent(DeviceManager deviceManager, Features features, final Event event) {
        EventReportingTask task = new EventReportingTask(this.buttonApi, deviceManager, features, Collections.singletonList(event), new Task.Listener<Void>(){

            @Override
            public void onTaskComplete(@Nullable Void object) {
            }

            @Override
            public void onTaskError(Throwable throwable) {
                Log.e((String)TAG, (String)String.format("Error reporting event [%s]", event.getName()), (Throwable)throwable);
            }
        });
        this.invokeIfConfigured(task);
    }

    private void invokeIfConfigured(Task<?> task) {
        if (this.isConfigured) {
            this.executorService.submit(task);
        } else {
            Log.d((String)TAG, (String)"Application ID unavailable! Queueing Task.");
            this.pendingTasks.add(task);
        }
    }
}

