/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.ButtonProductCompatible;
import com.usebutton.merchant.ButtonRepository;
import com.usebutton.merchant.module.ButtonUserActivity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class ButtonUserActivityImpl
implements ButtonUserActivity {
    @VisibleForTesting
    static final String EVENT_PRODUCT_VIEWED = "product-viewed";
    @VisibleForTesting
    static final String EVENT_ADD_TO_CART = "add-to-cart";
    @VisibleForTesting
    static final String EVENT_CART_VIEWED = "cart-viewed";
    private static ButtonUserActivity activity;
    @Nullable
    private ButtonRepository buttonRepository;
    @VisibleForTesting
    List<Event> queuedActivityEvents = new CopyOnWriteArrayList<Event>();

    ButtonUserActivityImpl() {
    }

    static ButtonUserActivity getInstance() {
        if (activity == null) {
            activity = new ButtonUserActivityImpl();
        }
        return activity;
    }

    @Override
    public void productViewed(@Nullable ButtonProductCompatible product) {
        Event event = new Event(EVENT_PRODUCT_VIEWED, product != null ? Collections.singletonList(product) : Collections.emptyList());
        this.trackOrQueueEvent(event);
    }

    @Override
    public void productAddedToCart(@Nullable ButtonProductCompatible product) {
        Event event = new Event(EVENT_ADD_TO_CART, product != null ? Collections.singletonList(product) : Collections.emptyList());
        this.trackOrQueueEvent(event);
    }

    @Override
    public void cartViewed(@Nullable List<ButtonProductCompatible> products) {
        Event event = new Event(EVENT_CART_VIEWED, products != null ? products : Collections.emptyList());
        this.trackOrQueueEvent(event);
    }

    private void trackOrQueueEvent(Event event) {
        if (this.buttonRepository != null) {
            this.buttonRepository.trackActivity(event.name, event.products);
        } else {
            this.queuedActivityEvents.add(event);
        }
    }

    void flushQueue(ButtonRepository buttonRepository) {
        this.buttonRepository = buttonRepository;
        for (Event event : this.queuedActivityEvents) {
            buttonRepository.trackActivity(event.name, event.products);
        }
        this.queuedActivityEvents.clear();
    }

    private static class Event {
        private final String name;
        private final List<ButtonProductCompatible> products;

        Event(String name, List<ButtonProductCompatible> products) {
            this.name = name;
            this.products = products;
        }
    }
}

