/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

final class ButtonUtil {
    private static final String TAG = ButtonUtil.class.getSimpleName();
    private static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ssZZZZZ";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ", Locale.US);
    private static final String EMAIL_REGEX = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])";
    private static final Pattern EMAIL_REGEX_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");
    private static final Pattern APP_ID_PATTERN = Pattern.compile("^app-[0-9a-zA-Z]+$");

    ButtonUtil() {
    }

    public static String formatDate(Date date) {
        return simpleDateFormat.format(date);
    }

    public static String formatTimestamp(long timestamp) {
        return ButtonUtil.formatDate(new Date(timestamp));
    }

    public static String base64Encode(String value) {
        return Base64.encodeToString((byte[])value.getBytes(), (int)2);
    }

    @Nullable
    public static String sha256Encode(String value) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = value.getBytes();
            messageDigest.update(bytes, 0, bytes.length);
            return ButtonUtil.encodeHex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)"Error has occurred", (Throwable)e);
            return null;
        }
    }

    public static boolean isValidEmail(String email) {
        return EMAIL_REGEX_PATTERN.matcher(email).matches();
    }

    public static boolean isApplicationIdValid(@Nullable String applicationId) {
        return applicationId != null && APP_ID_PATTERN.matcher(applicationId).matches();
    }

    private static String encodeHex(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

