/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.ApiRequest;
import com.usebutton.merchant.ButtonUtil;
import com.usebutton.merchant.ConnectionManager;
import com.usebutton.merchant.NetworkResponse;
import com.usebutton.merchant.PersistenceManager;
import com.usebutton.merchant.exception.ButtonNetworkException;
import com.usebutton.merchant.exception.HttpStatusException;
import com.usebutton.merchant.exception.NetworkNotFoundException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

final class ConnectionManagerImpl
implements ConnectionManager {
    private static final String TAG = ConnectionManagerImpl.class.getSimpleName();
    private static ConnectionManager instance;
    private static final int CONNECT_TIMEOUT;
    private static final int READ_TIMEOUT;
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String ENCODING = "UTF-8";
    private String applicationId;
    @VisibleForTesting
    String baseUrl;
    private final String userAgent;
    private final PersistenceManager persistenceManager;

    static ConnectionManager getInstance(String baseUrl, String userAgent, PersistenceManager persistenceManager) {
        if (instance == null) {
            instance = new ConnectionManagerImpl(baseUrl, userAgent, persistenceManager);
        }
        return instance;
    }

    @VisibleForTesting
    ConnectionManagerImpl(String baseUrl, String userAgent, PersistenceManager persistenceManager) {
        this.baseUrl = baseUrl;
        this.userAgent = userAgent;
        this.persistenceManager = persistenceManager;
    }

    @Override
    public void setApplicationId(String applicationId) {
        if (ButtonUtil.isApplicationIdValid(applicationId)) {
            this.applicationId = applicationId;
            this.baseUrl = String.format("https://%s.mobileapi.usebutton.com", applicationId);
        }
    }

    @Override
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public NetworkResponse executeRequest(@NonNull ApiRequest request) throws ButtonNetworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.getConnection(request.getPath());
            urlConnection.setRequestMethod(request.getRequestMethod().getValue());
            urlConnection.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
            Map<String, String> headers = request.getHeaders();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            JSONObject body = request.getBody();
            body.put("application_id", (Object)this.applicationId);
            body.put("session_id", (Object)this.persistenceManager.getSessionId());
            OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream(), ENCODING);
            writer.write(body.toString());
            writer.close();
            int responseCode = urlConnection.getResponseCode();
            Log.d((String)TAG, (String)("Request Body: " + body));
            Log.d((String)TAG, (String)("Response Code: " + responseCode));
            if (responseCode >= 400) {
                String message = "Unsuccessful Request. HTTP StatusCode: " + responseCode;
                Log.e((String)TAG, (String)message);
                throw new HttpStatusException(message, responseCode);
            }
            JSONObject responseJson = ConnectionManagerImpl.readResponseBody(urlConnection);
            this.refreshSessionIfAvailable(responseJson);
            NetworkResponse networkResponse = new NetworkResponse(responseCode, responseJson);
            return networkResponse;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error has occurred", (Throwable)e);
            throw new NetworkNotFoundException(e);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error has occurred", (Throwable)e);
            throw new ButtonNetworkException(((Object)((Object)e)).getClass().getSimpleName() + " has occurred");
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private HttpURLConnection getConnection(String path) throws IOException {
        URL url = new URL(this.baseUrl + path);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setConnectTimeout(CONNECT_TIMEOUT);
        urlConnection.setReadTimeout(READ_TIMEOUT);
        urlConnection.setRequestProperty("User-Agent", this.userAgent);
        urlConnection.setRequestProperty("Accept", CONTENT_TYPE_JSON);
        urlConnection.setDoOutput(true);
        return urlConnection;
    }

    private static JSONObject readResponseBody(HttpURLConnection connection) throws IOException, JSONException {
        String line;
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, ENCODING));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        return new JSONObject(response.toString());
    }

    private void refreshSessionIfAvailable(@Nullable JSONObject responseBody) {
        if (responseBody == null) {
            return;
        }
        try {
            JSONObject metaJson = responseBody.getJSONObject("meta");
            if (metaJson.has("session_id")) {
                String sessionId = metaJson.optString("session_id", null);
                if (sessionId != null) {
                    this.persistenceManager.setSessionId(sessionId);
                } else {
                    this.persistenceManager.clear();
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error parsing session data from response body", (Throwable)e);
        }
    }

    static {
        CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
        READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(15L);
    }
}

