/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.usebutton.merchant.ButtonUtil;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.Getter;
import com.usebutton.merchant.IdentifierForAdvertiserProvider;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class DeviceManagerImpl
implements DeviceManager {
    private final Context context;
    private final IdentifierForAdvertiserProvider advertiserProvider;
    private static DeviceManager deviceManager;
    @VisibleForTesting
    Getter<Long> clock = new Getter<Long>(){

        @Override
        public Long get() {
            return System.currentTimeMillis();
        }
    };
    @VisibleForTesting
    Getter<Date> date = new Getter<Date>(){

        @Override
        public Date get() {
            return new Date();
        }
    };

    static DeviceManager getInstance(Context context) {
        if (deviceManager == null) {
            IdentifierForAdvertiserProvider provider = new IdentifierForAdvertiserProvider(context);
            deviceManager = new DeviceManagerImpl(context, provider);
        }
        return deviceManager;
    }

    @VisibleForTesting
    DeviceManagerImpl(Context context, IdentifierForAdvertiserProvider advertiserProvider) {
        this.context = context;
        this.advertiserProvider = advertiserProvider;
    }

    @Override
    @WorkerThread
    @Nullable
    public String getAdvertisingId() {
        return this.advertiserProvider.getPrimaryIdentifier();
    }

    @VisibleForTesting
    String getScreenSize() {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        if (windowManager != null) {
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics out = new DisplayMetrics();
            display.getMetrics(out);
            return String.format(Locale.US, "%dx%d", out.widthPixels, out.heightPixels);
        }
        return "unknown";
    }

    @Override
    public Map<String, String> getSignals() {
        HashMap<String, String> signalsMap = new HashMap<String, String>();
        signalsMap.put("timezone", Calendar.getInstance().getTimeZone().getID());
        signalsMap.put("os", "android");
        signalsMap.put("os_version", Build.VERSION.RELEASE);
        signalsMap.put("device", String.format("%s %s", Build.MANUFACTURER, Build.MODEL));
        signalsMap.put("screen", this.getScreenSize());
        signalsMap.put("source", "button-merchant");
        Locale locale = Locale.getDefault();
        signalsMap.put("country", locale.getCountry());
        signalsMap.put("language", locale.getLanguage());
        return signalsMap;
    }

    @Override
    public String getTimeStamp() {
        return ButtonUtil.formatDate(this.date.get());
    }

    @Override
    public boolean isOldInstallation() {
        PackageInfo packageInfo = this.getPackageInfo();
        return packageInfo != null && packageInfo.firstInstallTime + TimeUnit.HOURS.toMillis(12L) < this.clock.get();
    }

    @Override
    public String getUserAgent() {
        StringBuilder sb = new StringBuilder();
        sb.append("com.usebutton.merchant/");
        sb.append(this.getSdkVersionName());
        sb.append('+');
        sb.append(this.getSdkVersionCode());
        sb.append(' ');
        sb.append("(Android ");
        sb.append(this.getAndroidVersionName());
        sb.append("; ");
        sb.append(this.getDeviceManufacturer());
        sb.append(' ');
        sb.append(this.getDeviceModel());
        sb.append("; ");
        sb.append(this.getPackageName());
        sb.append('/');
        sb.append(this.getVersionName());
        sb.append('+');
        sb.append(this.getVersionCode());
        sb.append("; ");
        sb.append(String.format(Locale.US, "Scale/%.1f; ", Float.valueOf(this.getScreenDensity())));
        Locale locale = this.getLocale();
        sb.append(locale.getLanguage()).append('_').append(locale.getCountry().toLowerCase()).append(')');
        return sb.toString();
    }

    private String getSdkVersionName() {
        return "1.6.1";
    }

    private int getSdkVersionCode() {
        return 1;
    }

    private String getAndroidVersionName() {
        return Build.VERSION.RELEASE;
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getDeviceModel() {
        return Build.MODEL;
    }

    @Nullable
    private String getPackageName() {
        PackageInfo packageInfo = this.getPackageInfo();
        return packageInfo != null ? packageInfo.packageName : null;
    }

    @Nullable
    private String getVersionName() {
        PackageInfo packageInfo = this.getPackageInfo();
        return packageInfo != null ? packageInfo.versionName : null;
    }

    private int getVersionCode() {
        PackageInfo packageInfo = this.getPackageInfo();
        return packageInfo != null ? packageInfo.versionCode : -1;
    }

    private float getScreenDensity() {
        return this.context.getResources().getDisplayMetrics().density;
    }

    private Locale getLocale() {
        return Locale.getDefault();
    }

    @Nullable
    private PackageInfo getPackageInfo() {
        try {
            String packageName = this.context.getPackageName();
            PackageManager packageManager = this.context.getPackageManager();
            return packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }
}

