/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.util.Log;
import androidx.annotation.Nullable;
import com.usebutton.merchant.ButtonUtil;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class Event {
    private static final String TAG = Event.class.getSimpleName();
    private final UUID id = UUID.randomUUID();
    private final long timestamp = System.currentTimeMillis();
    private final String name;
    private final Source source;
    @Nullable
    private final String sourceToken;
    private final JSONObject eventBody;

    Event(Name name, @Nullable String sourceToken) {
        this(name.eventName, Source.BUTTON, sourceToken, null);
    }

    Event(String name, @Nullable String sourceToken, @Nullable Map<String, String> properties) {
        this(name, Source.CUSTOM, sourceToken, properties);
    }

    private Event(String name, Source source, @Nullable String sourceToken, @Nullable Map<String, String> properties) {
        this.name = name;
        this.source = source;
        this.sourceToken = sourceToken;
        this.eventBody = new JSONObject();
        if (properties != null) {
            for (Map.Entry<String, String> prop : properties.entrySet()) {
                this.addProperty(prop.getKey(), prop.getValue());
            }
        }
    }

    void addProperty(Property key, @Nullable String value) {
        this.addProperty(key.propertyName, value);
    }

    private void addProperty(String key, @Nullable String value) {
        try {
            this.eventBody.put(key, (Object)value);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)String.format("Error adding property [%s] to event [%s]", key, this.name), (Throwable)e);
        }
    }

    public UUID getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public Source getSource() {
        return this.source;
    }

    @Nullable
    public String getSourceToken() {
        return this.sourceToken;
    }

    public JSONObject getEventBody() {
        return this.eventBody;
    }

    JSONObject toJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("name", (Object)this.name);
        json.put("source", (Object)this.source.sourceName);
        json.put("source_token", (Object)this.sourceToken);
        json.put("time", (Object)ButtonUtil.formatTimestamp(this.timestamp));
        json.put("uuid", (Object)this.id.toString());
        json.put("value", (Object)this.eventBody);
        if (this.source == Source.CUSTOM && this.eventBody.length() > 0) {
            JSONObject value = new JSONObject();
            value.put("extra", (Object)this.eventBody);
            json.put("value", (Object)value);
        }
        return json;
    }

    static enum Name {
        DEEPLINK_OPENED("btn:deeplink-opened");

        private final String eventName;

        private Name(String eventName) {
            this.eventName = eventName;
        }

        public String toString() {
            return this.eventName;
        }
    }

    static enum Source {
        BUTTON("button"),
        CUSTOM("custom");

        private final String sourceName;

        private Source(String sourceName) {
            this.sourceName = sourceName;
        }

        public String toString() {
            return this.sourceName;
        }
    }

    static enum Property {
        URL("url");

        private final String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String toString() {
            return this.propertyName;
        }
    }
}

