/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import androidx.annotation.Nullable;
import com.usebutton.merchant.ButtonApi;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.Event;
import com.usebutton.merchant.Task;
import com.usebutton.merchant.module.Features;
import java.util.List;

final class EventReportingTask
extends Task<Void> {
    private final ButtonApi buttonApi;
    private final List<Event> events;
    private final DeviceManager deviceManager;
    private final Features features;

    EventReportingTask(ButtonApi buttonApi, DeviceManager deviceManager, Features features, List<Event> events, Task.Listener<Void> listener) {
        super(listener);
        this.buttonApi = buttonApi;
        this.deviceManager = deviceManager;
        this.features = features;
        this.events = events;
    }

    @Override
    @Nullable
    Void execute() throws Exception {
        String advertisingId = this.features.getIncludesIfa() ? this.deviceManager.getAdvertisingId() : null;
        return this.buttonApi.postEvents(this.events, advertisingId);
    }
}

