/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import androidx.annotation.Nullable;
import com.usebutton.merchant.ButtonApi;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.PostInstallLink;
import com.usebutton.merchant.Task;
import com.usebutton.merchant.module.Features;

final class GetPendingLinkTask
extends Task<PostInstallLink> {
    private final ButtonApi buttonApi;
    private final DeviceManager deviceManager;
    private final Features features;
    private final String applicationId;

    GetPendingLinkTask(ButtonApi buttonApi, DeviceManager deviceManager, Features features, String applicationId, Task.Listener<PostInstallLink> listener) {
        super(listener);
        this.buttonApi = buttonApi;
        this.deviceManager = deviceManager;
        this.features = features;
        this.applicationId = applicationId;
    }

    @Override
    @Nullable
    PostInstallLink execute() throws Exception {
        String advertisingId = this.features.getIncludesIfa() ? this.deviceManager.getAdvertisingId() : null;
        return this.buttonApi.getPendingLink(this.applicationId, advertisingId, this.deviceManager.getSignals());
    }
}

