/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.usebutton.merchant.TtlReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

class IdentifierForAdvertiserProvider {
    private static final long IFA_TTL = TimeUnit.HOURS.toMillis(1L);
    private final Context context;
    private TtlReference<AdvertisingInfoReflectionProxy> proxyReference;

    IdentifierForAdvertiserProvider(Context context) {
        this.context = context.getApplicationContext();
    }

    @Nullable
    @WorkerThread
    public String getPrimaryIdentifier() {
        if (this.isTrackingLimited() || IdentifierForAdvertiserProvider.isOnMainThread()) {
            return null;
        }
        return this.getIdentifierProxy().getTrackingIdentifier(this.context);
    }

    public boolean isTrackingLimited() {
        return this.getIdentifierProxy().isAdTrackingLimited(this.context);
    }

    private AdvertisingInfoReflectionProxy getIdentifierProxy() {
        if (this.proxyReference == null || this.proxyReference.isDead()) {
            this.proxyReference = new TtlReference<AdvertisingInfoReflectionProxy>(new AdvertisingInfoReflectionProxy(), IFA_TTL);
        }
        return this.proxyReference.get();
    }

    private static boolean isOnMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    private static class AdvertisingInfoReflectionProxy {
        private static final String CLASS = "com.google.android.gms.ads.identifier.AdvertisingIdClient";
        private static final String METHOD_INFO = "getAdvertisingIdInfo";
        private static final String METHOD_TRACKING = "isLimitAdTrackingEnabled";
        private static final String METHOD_IDENTIFIER = "getId";
        private boolean initialized;
        private Method getInfoMethod;
        private Class<?> advertisingClient;

        AdvertisingInfoReflectionProxy() {
            try {
                this.advertisingClient = Class.forName(CLASS);
                this.getInfoMethod = this.advertisingClient.getDeclaredMethod(METHOD_INFO, Context.class);
                this.initialized = true;
            }
            catch (Exception e) {
                this.initialized = false;
            }
        }

        boolean isAdTrackingLimited(Context context) {
            if (!this.initialized) {
                return false;
            }
            try {
                Object adInfo = this.getAdInfo(context);
                return (Boolean)adInfo.getClass().getMethod(METHOD_TRACKING, new Class[0]).invoke(adInfo, new Object[0]);
            }
            catch (Exception e) {
                return false;
            }
        }

        String getTrackingIdentifier(Context context) {
            if (!this.initialized) {
                return null;
            }
            try {
                Object adInfo = this.getAdInfo(context);
                return (String)adInfo.getClass().getMethod(METHOD_IDENTIFIER, new Class[0]).invoke(adInfo, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        private Object getAdInfo(Context context) throws IllegalAccessException, InvocationTargetException {
            return this.getInfoMethod.invoke(this.advertisingClient, context);
        }
    }
}

