/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import androidx.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Order {
    private String id;
    @Deprecated
    private long amount;
    private String currencyCode;
    private Date purchaseDate;
    private List<LineItem> lineItems;
    @Nullable
    private String customerOrderId;
    @Nullable
    private Customer customer;

    private Order(Builder builder) {
        this.id = builder.id;
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
        this.purchaseDate = builder.purchaseDate;
        this.lineItems = builder.lineItems;
        this.customerOrderId = builder.customerOrderId;
        this.customer = builder.customer;
    }

    public String getId() {
        return this.id;
    }

    @Deprecated
    public long getAmount() {
        return this.amount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @Nullable
    public String getCustomerOrderId() {
        return this.customerOrderId;
    }

    @Nullable
    public Customer getCustomer() {
        return this.customer;
    }

    public static class Builder {
        private String id;
        @Deprecated
        private long amount = 0L;
        private String currencyCode = "USD";
        private Date purchaseDate;
        private List<LineItem> lineItems;
        @Nullable
        private String customerOrderId;
        @Nullable
        private Customer customer;

        @Deprecated
        public Builder(String id) {
            this.id = id;
        }

        public Builder(String id, Date purchaseDate, List<LineItem> lineItems) {
            this.id = id;
            this.purchaseDate = purchaseDate;
            this.lineItems = lineItems;
        }

        @Deprecated
        public Builder setAmount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder setCustomerOrderId(String customerOrderId) {
            this.customerOrderId = customerOrderId;
            return this;
        }

        public Builder setCustomer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public Order build() {
            return new Order(this);
        }
    }

    public static class Customer {
        private String id;
        @Nullable
        private String email;
        @Nullable
        private Boolean isNew;

        private Customer(Builder builder) {
            this.id = builder.id;
            this.email = builder.email;
            this.isNew = builder.isNew;
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public String getEmail() {
            return this.email;
        }

        @Nullable
        public Boolean isNew() {
            return this.isNew;
        }

        public static class Builder {
            private String id;
            @Nullable
            private String email;
            @Nullable
            private Boolean isNew;

            public Builder(String id) {
                this.id = id;
            }

            public Builder setEmail(String email) {
                this.email = email;
                return this;
            }

            public Builder setIsNew(boolean isNew) {
                this.isNew = isNew;
                return this;
            }

            public Customer build() {
                return new Customer(this);
            }
        }
    }

    public static class LineItem {
        private String id;
        private long total;
        private int quantity;
        @Nullable
        private String description;
        @Nullable
        private String sku;
        @Nullable
        private String upc;
        @Nullable
        private List<String> category;
        @Nullable
        private Map<String, String> attributes;

        private LineItem(Builder builder) {
            this.id = builder.id;
            this.total = builder.total;
            this.quantity = builder.quantity;
            this.description = builder.description;
            this.sku = builder.sku;
            this.upc = builder.upc;
            this.category = builder.category;
            this.attributes = builder.attributes;
        }

        public String getId() {
            return this.id;
        }

        public long getTotal() {
            return this.total;
        }

        public int getQuantity() {
            return this.quantity;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nullable
        public String getSku() {
            return this.sku;
        }

        @Nullable
        public String getUpc() {
            return this.upc;
        }

        @Nullable
        public List<String> getCategory() {
            return this.category;
        }

        @Nullable
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public static class Builder {
            private String id;
            private long total;
            private int quantity = 1;
            @Nullable
            private String description;
            @Nullable
            private String sku;
            @Nullable
            private String upc;
            @Nullable
            private List<String> category;
            @Nullable
            private Map<String, String> attributes;

            public Builder(String id, long total) {
                this.id = id;
                this.total = total;
            }

            public Builder setQuantity(int quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setSku(String sku) {
                this.sku = sku;
                return this;
            }

            public Builder setUpc(String upc) {
                this.upc = upc;
                return this;
            }

            public Builder setCategory(List<String> category) {
                this.category = category;
                return this;
            }

            public Builder setAttributes(Map<String, String> attributes) {
                this.attributes = attributes;
                return this;
            }

            public LineItem build() {
                return new LineItem(this);
            }
        }
    }
}

