/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.PersistenceManager;

final class PersistenceManagerImpl
implements PersistenceManager {
    private static PersistenceManager persistenceManager;
    private final SharedPreferences sharedPreferences;

    static PersistenceManager getInstance(Context context) {
        if (persistenceManager == null) {
            persistenceManager = new PersistenceManagerImpl(context);
        }
        return persistenceManager;
    }

    @VisibleForTesting
    PersistenceManagerImpl(Context context) {
        this.sharedPreferences = context.getSharedPreferences("button_shared_preferences", 0);
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sharedPreferences.edit().putString("btn_session_id", sessionId).apply();
    }

    @Override
    @Nullable
    public String getSessionId() {
        return this.sharedPreferences.getString("btn_session_id", null);
    }

    @Override
    public void setSourceToken(String sourceToken) {
        this.sharedPreferences.edit().putString("btn_source_token", sourceToken).apply();
    }

    @Override
    @Nullable
    public String getSourceToken() {
        return this.sharedPreferences.getString("btn_source_token", null);
    }

    @Override
    public void clear() {
        this.sharedPreferences.edit().clear().apply();
    }

    @Override
    public boolean checkedDeferredDeepLink() {
        return this.sharedPreferences.getBoolean("btn_checked_deferred_deep_link", false);
    }

    @Override
    public void updateCheckDeferredDeepLink(boolean checkedDeferredDeepLink) {
        this.sharedPreferences.edit().putBoolean("btn_checked_deferred_deep_link", checkedDeferredDeepLink).apply();
    }

    static final class Key {
        private static final String PREFIX = "btn_";
        static final String SESSION_ID = "btn_session_id";
        static final String SOURCE_TOKEN = "btn_source_token";
        static final String CHECKED_DEFERRED_DEEP_LINK = "btn_checked_deferred_deep_link";

        Key() {
        }
    }
}

