/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.ButtonApi;
import com.usebutton.merchant.DeviceManager;
import com.usebutton.merchant.Order;
import com.usebutton.merchant.Task;
import com.usebutton.merchant.ThreadManager;
import com.usebutton.merchant.exception.ButtonNetworkException;
import com.usebutton.merchant.exception.HttpStatusException;
import com.usebutton.merchant.exception.NetworkNotFoundException;
import com.usebutton.merchant.module.Features;

class PostOrderTask
extends Task {
    private final ButtonApi buttonApi;
    private final String applicationId;
    private final String sourceToken;
    private final Order order;
    private final DeviceManager deviceManager;
    private final Features features;
    private final ThreadManager threadManager;
    @VisibleForTesting
    static final int MAX_RETRIES = 4;
    private int retryCount = 0;

    PostOrderTask(@Nullable Task.Listener listener, ButtonApi buttonApi, Order order, String applicationId, String sourceToken, DeviceManager deviceManager, Features features, ThreadManager threadManager) {
        super(listener);
        this.buttonApi = buttonApi;
        this.order = order;
        this.applicationId = applicationId;
        this.sourceToken = sourceToken;
        this.deviceManager = deviceManager;
        this.features = features;
        this.threadManager = threadManager;
    }

    @Nullable
    Void execute() throws Exception {
        String advertisingId = this.features.getIncludesIfa() ? this.deviceManager.getAdvertisingId() : null;
        while (true) {
            try {
                return this.buttonApi.postOrder(this.order, this.applicationId, this.sourceToken, advertisingId);
            }
            catch (ButtonNetworkException exception) {
                if (!this.shouldRetry(exception)) {
                    throw exception;
                }
                ++this.retryCount;
                continue;
            }
            break;
        }
    }

    private boolean shouldRetry(ButtonNetworkException exception) throws InterruptedException {
        HttpStatusException httpStatusException;
        if (this.retryCount >= 4) {
            return false;
        }
        double delay = this.getRetryDelay();
        if (exception instanceof NetworkNotFoundException) {
            this.threadManager.sleep((long)delay);
            return true;
        }
        if (exception instanceof HttpStatusException && (httpStatusException = (HttpStatusException)exception).wasServerError()) {
            this.threadManager.sleep((long)delay);
            return true;
        }
        return false;
    }

    private double getRetryDelay() {
        return Math.pow(2.0, this.retryCount) * 100.0;
    }
}

