/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.ButtonRepository;
import java.util.List;

class TestManager {
    @VisibleForTesting
    static final String TEST_HARNESS_SCHEME = "button-brand-test";
    @VisibleForTesting
    static final String TEST_HARNESS_PACKAGE = "com.usebutton.brandtest";
    @VisibleForTesting
    static final String ACTION_QUIT = "quit";
    @VisibleForTesting
    static final String ACTION_GET_TOKEN = "get-token";
    @VisibleForTesting
    static final String ACTION_ECHO_TOKEN = "echo";
    @VisibleForTesting
    static final String ACTION_POST_INSTALL = "test-post-install";
    @VisibleForTesting
    static final String ACTION_VERSION = "version";
    @VisibleForTesting
    static final String ACTION_RESPONSE = "action-response";
    private final Context context;
    private final ButtonRepository buttonRepository;
    private final Terminator terminator;

    TestManager(Context context, ButtonRepository buttonRepository, Terminator terminator) {
        this.context = context;
        this.buttonRepository = buttonRepository;
        this.terminator = terminator;
    }

    public void parseIntent(Intent intent) {
        Uri data = intent.getData();
        if (data == null) {
            return;
        }
        String echoParam = data.getQueryParameter("btn_test_echo");
        List segments = data.getPathSegments();
        if (segments != null && segments.size() == 2 && "action".equals(segments.get(0))) {
            String action;
            switch (action = (String)segments.get(1)) {
                case "quit": {
                    this.quit();
                    break;
                }
                case "get-token": {
                    this.sendToken(ACTION_GET_TOKEN);
                    break;
                }
                case "test-post-install": {
                    this.sendPostInstallerResult();
                    break;
                }
                case "version": {
                    this.sendLibraryVersion();
                    break;
                }
            }
        } else if ("true".equals(echoParam)) {
            this.sendToken(ACTION_ECHO_TOKEN);
        }
    }

    private void quit() {
        Uri responseDeeplink = new Uri.Builder().scheme(TEST_HARNESS_SCHEME).authority(ACTION_RESPONSE).appendPath(ACTION_QUIT).build();
        boolean successful = this.submitResult(responseDeeplink);
        if (successful) {
            this.terminator.terminate();
        }
    }

    private void sendToken(String requestSource) {
        String token = this.buttonRepository.getSourceToken();
        Uri responseDeeplink = new Uri.Builder().scheme(TEST_HARNESS_SCHEME).authority(ACTION_RESPONSE).appendPath(requestSource).appendQueryParameter("btn_ref", token).build();
        this.submitResult(responseDeeplink);
    }

    private void sendPostInstallerResult() {
        boolean checked = this.buttonRepository.checkedDeferredDeepLink();
        Uri responseDeeplink = new Uri.Builder().scheme(TEST_HARNESS_SCHEME).authority(ACTION_RESPONSE).appendPath(ACTION_POST_INSTALL).appendQueryParameter("success", String.valueOf(checked)).build();
        this.submitResult(responseDeeplink);
    }

    private void sendLibraryVersion() {
        Uri responseDeeplink = new Uri.Builder().scheme(TEST_HARNESS_SCHEME).authority(ACTION_RESPONSE).appendPath(ACTION_VERSION).appendQueryParameter(ACTION_VERSION, "1.6.1").build();
        this.submitResult(responseDeeplink);
    }

    private boolean submitResult(Uri result) {
        Intent intent = new Intent("android.intent.action.VIEW", result);
        intent.setPackage(TEST_HARNESS_PACKAGE);
        intent.setFlags(0x20000000);
        try {
            this.context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
    }

    static class Terminator {
        Terminator() {
        }

        void terminate() {
            Process.killProcess((int)Process.myPid());
        }
    }
}

