/*
 * Decompiled with CFR 0.152.
 */
package com.usebutton.merchant;

import android.os.SystemClock;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.usebutton.merchant.TimeProvider;

class TtlReference<T> {
    public static final TimeProvider REALTIME_MILLIS_PROVIDER = new TimeProvider(){

        @Override
        public long getTimeInMs() {
            return SystemClock.elapsedRealtime();
        }
    };
    private final T object;
    private final long timeOfDeath;
    private final TimeProvider timeProvider;

    TtlReference(@NonNull T object, @IntRange(from=1L) long ttl) {
        this(REALTIME_MILLIS_PROVIDER, object, ttl);
    }

    @VisibleForTesting
    TtlReference(@NonNull TimeProvider timeProvider, @NonNull T object, @IntRange(from=1L) long ttl) {
        this.timeProvider = timeProvider;
        this.object = object;
        this.timeOfDeath = timeProvider.getTimeInMs() + ttl;
    }

    public T get() {
        if (this.isDead()) {
            return null;
        }
        return this.object;
    }

    public boolean isDead() {
        return this.timeProvider.getTimeInMs() > this.timeOfDeath;
    }
}

