/*
 * Decompiled with CFR 0.152.
 */
package com.useoptic.document.spring_boot;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Order(value=0x7FFFFFFF)
@Component
public class OpticDocumentingFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String string;
        Enumeration enumeration;
        String string2;
        if (System.getenv("OPTIC_SERVER_LISTENING") == null) {
            System.out.println("skipping optic filter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string3 = System.getenv("OPTIC_SERVER_HOST");
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        ContentCachingRequestWrapper contentCachingRequestWrapper = new ContentCachingRequestWrapper(httpServletRequest);
        ContentCachingResponseWrapper contentCachingResponseWrapper = new ContentCachingResponseWrapper(httpServletResponse);
        filterChain.doFilter((ServletRequest)contentCachingRequestWrapper, (ServletResponse)contentCachingResponseWrapper);
        byte[] byArray = contentCachingRequestWrapper.getContentAsByteArray();
        byte[] byArray2 = contentCachingResponseWrapper.getContentAsByteArray();
        contentCachingResponseWrapper.copyBodyToResponse();
        System.out.println("response bytes " + Integer.toString(byArray2.length));
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)httpServletRequest.getRequestURI()).query(httpServletRequest.getQueryString()).scheme("http").host(string3).port(30334).build();
        System.out.println(uriComponents.toString());
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        Enumeration enumeration2 = httpServletRequest.getHeaderNames();
        while (enumeration2.hasMoreElements()) {
            string2 = (String)enumeration2.nextElement();
            enumeration = httpServletRequest.getHeaders(string2);
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                linkedMultiValueMap.add((Object)string2, (Object)string);
                System.out.println(string2 + ": " + string);
            }
        }
        string2 = new HttpEntity((Object)byArray, (MultiValueMap)linkedMultiValueMap);
        try {
            enumeration = restTemplate.exchange(uriComponents.toUri(), HttpMethod.resolve((String)httpServletRequest.getMethod()), (HttpEntity)string2, String.class);
            System.out.println("interactionId: " + (String)enumeration.getBody());
            string = UriComponentsBuilder.newInstance().host(string3).scheme("http").port(30335).pathSegment(new String[]{"interactions"}).pathSegment(new String[]{(String)enumeration.getBody()}).pathSegment(new String[]{"status"}).pathSegment(new String[]{Integer.toString(contentCachingResponseWrapper.getStatusCode())}).build();
            System.out.println(string.toString());
            LinkedMultiValueMap linkedMultiValueMap2 = new LinkedMultiValueMap();
            Collection collection = httpServletResponse.getHeaderNames();
            for (String string4 : collection) {
                Collection collection2 = httpServletResponse.getHeaders(string4);
                for (String string5 : collection2) {
                    linkedMultiValueMap2.add((Object)string4, (Object)string5);
                    System.out.println(string4 + ": " + string5);
                }
            }
            HttpEntity httpEntity = new HttpEntity((Object)byArray2, (MultiValueMap)linkedMultiValueMap2);
            restTemplate.exchange(string.toUri(), HttpMethod.POST, httpEntity, Void.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
    }
}

