/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.ruleset.service;

import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation;
import com.usercentrics.sdk.v2.location.service.ILocationService;
import com.usercentrics.sdk.v2.ruleset.data.GeoRule;
import com.usercentrics.sdk.v2.ruleset.data.RuleSet;
import com.usercentrics.sdk.v2.ruleset.data.SessionGeoRule;
import com.usercentrics.sdk.v2.ruleset.repository.IRuleSetRepository;
import com.usercentrics.sdk.v2.ruleset.service.IRuleSetService;
import com.usercentrics.sdk.v2.ruleset.service.RuleSetService;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0013j\b\u0012\u0004\u0012\u00020\u0010`\u00142\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/usercentrics/sdk/v2/ruleset/service/RuleSetService;", "Lcom/usercentrics/sdk/v2/ruleset/service/IRuleSetService;", "ruleSetRepository", "Lcom/usercentrics/sdk/v2/ruleset/repository/IRuleSetRepository;", "locationService", "Lcom/usercentrics/sdk/v2/location/service/ILocationService;", "(Lcom/usercentrics/sdk/v2/ruleset/repository/IRuleSetRepository;Lcom/usercentrics/sdk/v2/location/service/ILocationService;)V", "findRuleForLocation", "Lcom/usercentrics/sdk/v2/ruleset/data/GeoRule;", "ruleSet", "Lcom/usercentrics/sdk/v2/ruleset/data/RuleSet;", "location", "Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "getActiveSettingsId", "Lcom/usercentrics/sdk/v2/ruleset/data/SessionGeoRule;", "id", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "populateAllSettingsIds", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nRuleSetService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleSetService.kt\ncom/usercentrics/sdk/v2/ruleset/service/RuleSetService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1855#2,2:74\n*S KotlinDebug\n*F\n+ 1 RuleSetService.kt\ncom/usercentrics/sdk/v2/ruleset/service/RuleSetService\n*L\n52#1:74,2\n*E\n"})
public final class RuleSetService
implements IRuleSetService {
    @NotNull
    private final IRuleSetRepository ruleSetRepository;
    @NotNull
    private final ILocationService locationService;

    public RuleSetService(@NotNull IRuleSetRepository ruleSetRepository, @NotNull ILocationService locationService2) {
        Intrinsics.checkNotNullParameter((Object)ruleSetRepository, (String)"ruleSetRepository");
        Intrinsics.checkNotNullParameter((Object)locationService2, (String)"locationService");
        this.ruleSetRepository = ruleSetRepository;
        this.locationService = locationService2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getActiveSettingsId(@NotNull String var1_1, @NotNull Continuation<? super SessionGeoRule> var2_2) {
        if (!(var2_2 instanceof getActiveSettingsId.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ RuleSetService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getActiveSettingsId(null, (Continuation<? super SessionGeoRule>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                hasCachedLocation = this.locationService.loadLocation();
                $continuation.L$0 = this;
                $continuation.Z$0 = hasCachedLocation;
                $continuation.label = 1;
                v0 = this.ruleSetRepository.fetchRuleSet((String)id, hasCachedLocation == false, (Continuation<? super Pair<RuleSet, UsercentricsLocation>>)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                hasCachedLocation = $continuation.Z$0;
                this = (RuleSetService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((location = (UsercentricsLocation)(fetchedRuleSet = (Pair)v0).getSecond()).isEmpty()) {
                    if (!hasCachedLocation) {
                        throw new UsercentricsException("Unable to initialise because location is not available; check permission or connectivity.", null, 2, null);
                    }
                    location = this.locationService.getLocation();
                }
                ruleSet = (RuleSet)fetchedRuleSet.getFirst();
                targetRule = this.findRuleForLocation(ruleSet, location);
                var8_11 = null;
                noShow = false;
                if (targetRule == null) {
                    noShow = ruleSet.getDefaultRule().getNoShow();
                    var8_11 = ruleSet.getDefaultRule().getSettingsId();
                } else {
                    settingsId = targetRule.getSettingsId();
                }
                return new SessionGeoRule(settingsId, noShow != false, location, this.populateAllSettingsIds(ruleSet));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final HashSet<String> populateAllSettingsIds(RuleSet ruleSet) {
        Object[] objectArray = new String[]{ruleSet.getDefaultRule().getSettingsId()};
        HashSet result = SetsKt.hashSetOf((Object[])objectArray);
        Iterable $this$forEach$iv = ruleSet.getRules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeoRule it = (GeoRule)element$iv;
            boolean bl = false;
            result.add(it.getSettingsId());
        }
        return result;
    }

    private final GeoRule findRuleForLocation(RuleSet ruleSet, UsercentricsLocation location) {
        GeoRule geoRule;
        GeoRule regionRule = null;
        GeoRule countryRule = null;
        for (GeoRule rule : ruleSet.getRules()) {
            if (rule.getLocations().contains(location.getRegionCode())) {
                regionRule = rule;
                break;
            }
            if (!rule.getLocations().contains(location.getCountryCode())) continue;
            countryRule = rule;
        }
        if ((geoRule = regionRule) == null) {
            geoRule = countryRule;
        }
        return geoRule;
    }
}

