package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.UsercentricsContext
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class AppLovinMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
    val context: UsercentricsContext?,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.applovin.sdk.AppLovinPrivacySettings")

            if (variant == UsercentricsVariant.CCPA) {
                com.applovin.sdk.AppLovinPrivacySettings.setDoNotSell(!consent, context)
            } else {
                com.applovin.sdk.AppLovinPrivacySettings.setHasUserConsent(consent, context)
            }
            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }
}
