package com.usercentrics.sdk.mediation.sdk

import com.google.firebase.crashlytics.ktx.crashlytics
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class CrashlyticsMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.google.firebase.crashlytics.FirebaseCrashlytics")
            com.google.firebase.ktx.Firebase.crashlytics.setCrashlyticsCollectionEnabled(consent)
            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }
}
