package com.usercentrics.sdk.mediation.sdk

import com.google.firebase.analytics.FirebaseAnalytics
import com.google.firebase.analytics.ktx.analytics
import com.google.firebase.ktx.Firebase
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.mediation.data.MediationGranularConsent
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class FirebaseAdvertisingMediationSDK actual constructor(
    name: String,
    logger: UsercentricsLogger,
    vendorId: Int,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics")

            val consentStatus = consentStatus(consent)

            Firebase.analytics.setConsent(
                mapOf(
                    FirebaseAnalytics.ConsentType.AD_STORAGE to consentStatus,
                    FirebaseAnalytics.ConsentType.AD_PERSONALIZATION to consentStatus,
                    FirebaseAnalytics.ConsentType.AD_USER_DATA to consentStatus,
                )
            )
            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }

    override fun applyGranular(granularConsent: MediationGranularConsent): Boolean {
        // for TCF, Firebase SDKs get the TCString automatically and set their flags
        return true
    }

    private fun consentStatus(consent: Boolean): FirebaseAnalytics.ConsentStatus {
        return if (consent) {
            FirebaseAnalytics.ConsentStatus.GRANTED
        } else {
            FirebaseAnalytics.ConsentStatus.DENIED
        }
    }
}
