package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class IronSourceMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.ironsource.mediationsdk.IronSource")

            if (variant == UsercentricsVariant.CCPA) {
                com.ironsource.mediationsdk.IronSource.setMetaData("do_not_sell", (!consent).toString())
            } else {
                com.ironsource.mediationsdk.IronSource.setConsent(consent)
            }

            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }
}
