package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class SingularMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.singular.sdk.Singular")
            limitDataSharing(consent)
            if (consent) {
                com.singular.sdk.Singular.resumeAllTracking()
                com.singular.sdk.Singular.trackingOptIn()
            } else {
                com.singular.sdk.Singular.stopAllTracking();
            }
            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }

    private fun limitDataSharing(consent: Boolean) {
        com.singular.sdk.Singular.limitDataSharing(!consent)
    }
}
